% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumSingleton.R
\name{NumSingleton}
\alias{NumSingleton}
\title{Decoding of \code{singletonMethod}}
\usage{
NumSingleton(singletonMethod)
}
\arguments{
\item{singletonMethod}{String to be decoded. If necessary, the input string is extended with \code{F}'s.}
}
\value{
A character vector or \code{NULL}
}
\description{
A \code{\link{GaussSuppression}} \code{singletonMethod} starting with \code{"num"} is decoded into separate characters.
}
\details{
Any \code{F} means the feature is turned off.
Other characters have the following meaning:
\enumerate{
\item \code{singleton2Primary} (1st character):
\itemize{
\item \code{T}: All singletons are forced to be primary suppressed.
\item \code{t}: Non-published singletons are primary suppressed.
}
\item \code{integerUnique} (2nd character):
\itemize{
\item \code{T}: Integer values representing the unique contributors are utilized.  Error if \code{singleton} not supplied as integer.
\item \code{t}: As \code{T} above, but instead of error, the feature is turned off  (as \code{F}) if \code{singleton} is not supplied as integer.
}
\item \code{sum2} (3rd character):
\itemize{
\item \code{T}: Imaginary primary suppressed cells are made,
which are the sum of some suppressed inner cells and which can be divided into two components.
At least one component is singleton contributor. The other component may be an inner cell.
\item \code{H}: As \code{T} above. And in addition, the other component can be any primary suppressed published cell.
This method may be computationally demanding for big data.
}
}
}
\examples{
NumSingleton("numTFF")
NumSingleton("numFTT")
NumSingleton("numttH")
}
