% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitfun.SP.R
\name{Fitting-Functions}
\alias{Fitting-Functions}
\alias{lasso.glmnet}
\alias{adalasso.glmnet}
\alias{adalassoCV.glmnet}
\alias{ridge.glmnet}
\alias{lasso.lars}
\title{Four Fitting-Functions that can be used as an input of \code{fitfun.SP} argument 
to obtain the solution paths for the SPSP algorithm. The users can also customize a
function to generate the solution paths. As long as the customized function take 
arguments x, y, family, standardize, and intercept, and return an object of class 
\code{glmnet}, \code{lars} (or \code{SCAD}, \code{MCP} in the future).}
\usage{
lasso.glmnet(x, y, family, standardize, intercept, ...)

adalasso.glmnet(x, y, family, standardize, intercept, ...)

adalassoCV.glmnet(x, y, family, standardize, intercept, ...)

ridge.glmnet(x, y, family, standardize, intercept, ...)

lasso.lars(x, y, family, standardize, intercept, ...)
}
\arguments{
\item{x}{a matrix of the independent variables. The dimensions are (nobs) and (nvars); each row is an observation vector.}

\item{y}{Response variable. Quantitative for \code{family="gaussian"} or \code{family="poisson"} (non-negative counts). 
For \code{family="binomial"} should be either a factor with two levels.}

\item{family}{Response type. Either a character string representing one of the built-in families,
or else a glm() family object.}

\item{standardize}{logical argument. Should conduct standardization before the estimation? Default is TRUE.}

\item{intercept}{logical. If x is a data.frame, this argument determines if the resulting model matrix should contain 
a separate intercept or not. Default is TRUE.}

\item{...}{Additional optional arguments.}
}
\value{
An object of class \code{"glmnet"} is returned to provide solution paths for the SPSP algorithm.

An object of class \code{"glmnet"} is returned to provide solution paths for the SPSP algorithm.

An object of class \code{"glmnet"} is returned to provide solution paths for the SPSP algorithm.

An object of class \code{"glmnet"} is returned to provide solution paths for the SPSP algorithm.

An object of class \code{"lars"} is returned to provide solution paths for the SPSP algorithm.
}
\description{
Four Fitting-Functions that can be used as an input of \code{fitfun.SP} argument 
to obtain the solution paths for the SPSP algorithm. The users can also customize a
function to generate the solution paths. As long as the customized function take 
arguments x, y, family, standardize, and intercept, and return an object of class 
\code{glmnet}, \code{lars} (or \code{SCAD}, \code{MCP} in the future).

\code{lasso.glmnet} uses lasso selection from \code{\link[glmnet]{glmnet}}.

\code{adalasso.glmnet} the function to conduct the adaptive lasso selection using the \code{lambda.1se} from cross-validation lasso method
to obtain initial coefficients. It uses package \code{\link[glmnet]{glmnet}}.

\code{adalassoCV.glmnet} adaptive lasso selection using the \code{lambda.1se} from cross-validation adaptive 
  lasso method to obtain initial coefficients. It uses package \code{\link[glmnet]{glmnet}}.

\code{ridge.glmnet} uses ridge regression to obtain the solution path.

\code{lasso.lars} uses lasso selection in \code{\link[lars]{lars}} to obtain the solution path.
}
