% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotTools.R
\name{getReplicates}
\alias{getReplicates}
\title{get number of replicates}
\usage{
getReplicates(x, X)
}
\arguments{
\item{x}{row vector}

\item{X}{matrix}
}
\description{
determine how often appears x in X
}
\details{
can be used to determine the number of
replicates/repeated evaluations of a solution x
}
\examples{
k <- 2
n <- 4
A <- matrix(1:(k*n),n,k, byrow = TRUE)
X <- rbind(A,A,A)
x <- A[1,]
## should be 3:
getReplicates(x,X)

## U has unique entries
U <- X[!duplicated(X), ]
## should be 1:
getReplicates(x,U)

}
