% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildKrigingForrester.R
\name{predict.kriging}
\alias{predict.kriging}
\title{Predict Kriging Model}
\usage{
\method{predict}{kriging}(object, newdata, ...)
}
\arguments{
\item{object}{Kriging model (settings and parameters) of class \code{kriging}.}

\item{newdata}{design matrix to be predicted}

\item{...}{not used}
}
\value{
list with predicted mean \code{y}, uncertainty / standard deviation \code{s} (optional) and expected improvement \code{ei} (optional). 
Whether \code{s} and \code{ei} are returned is specified by the vector of strings \code{object$target}, which then contains \code{"s"} and \code{"ei"}.
}
\description{
Predict with Kriging model produced by \code{\link{buildKriging}}.
}
\examples{
## Test-function:
braninFunction <- function (x) {	
	(x[2]  - 5.1/(4 * pi^2) * (x[1] ^2) + 5/pi * x[1]  - 6)^2 +
 10 * (1 - 1/(8 * pi)) * cos(x[1] ) + 10
}
## Create design points
x <- cbind(runif(20)*15-5,runif(20)*15)
## Compute observations at design points (for Branin function)
y <- as.matrix(apply(x,1,braninFunction))
## Create model
fit <- buildKriging(x,y)
fit$target <- c("y","s","ei")
## first estimate error with regressive predictor
predict(fit,x)

}
\seealso{
\code{\link{buildKriging}}
}
\keyword{internal}
