% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyclone.R
\name{funCyclone}
\alias{funCyclone}
\title{Objective function - Cyclone Simulation: Barth/Muschelknautz}
\usage{
funCyclone(x, deterministic = c(T, T, T), cyclone = list(Da = 1260, H =
  2500, Dt = 420, Ht = 650, He = 600, Be = 200), fluid = list(Mu = 18.5 *
  10^(-6), Vp = 5000, Rhop = 2000, Rhof = 1.204, Croh = 50),
  noiseLevel = list(Vp = 0.1, Rhop = 0.05))
}
\arguments{
\item{x}{vector of length at least one and up to six, specifying non-default geometrical parameters: Da, H, Dt, Ht, He, Be}

\item{deterministic}{binary vector. First element specifies whether volume flow is deterministic or not. Second element specifies whether particle density is deterministic or not. Third element specifies whether particle diameters are deterministic or not. Default: All are deterministic (TRUE).}

\item{cyclone}{list of a default cyclone's geometrical parameters: fluid$Da, fluid$H, fluid$Dt, fluid$Ht, fluid$He and fluid$Be}

\item{fluid}{list of default fluid parameters: fluid$Mu, fluid$Vp, fluid$Rhop, fluid$Rhof and fluid$Croh}

\item{noiseLevel}{list of noise levels for volume flow (noiseLevel$Vp) and particle density (noiseLevel$Rhop), only used if non-deterministic.}
}
\value{
returns a function that calculates the fractional efficiency for the specified diameter, see example.
}
\description{
Calculate cyclone collection efficiency. A simple, physics-based
optimization problem (potentially bi-objective). See the references [1,2].
}
\examples{
## Call directly
funCyclone(c(1260,2500))
## create vectorized target funcion, vectorized, first objective only
## Also: negated, since SPOT always does minimization.
tfunvecF1 <-function(x){-apply(x,1,funCyclone)[1,]}
tfunvecF1(matrix(c(1260,2500,1000,2000),2,2,byrow=TRUE))
## optimize with spot
res <- spot(fun=tfunvecF1,lower=c(1000,2000),upper=c(2000,3000),
   control=list(modelControl=list(target="ei"),
   model=buildKriging,optimizer=optimLBFGSB,plots=TRUE)) 
## best found solution ...
res$xbest
## ... and its objective function value
res$ybest

}
\references{
[1] Zaefferer, M.; Breiderhoff, B.; Naujoks, B.; Friese, M.; Stork, J.; Fischbach, A.; Flasch, O.; Bartz-Beielstein, T. Tuning Multi-objective Optimization Algorithms for Cyclone Dust Separators Proceedings of the 2014 Conference on Genetic and Evolutionary Computation, ACM, 2014, 1223-1230 \cr\cr
[2] Breiderhoff, B.; Bartz-Beielstein, T.; Naujoks, B.; Zaefferer, M.; Fischbach, A.; Flasch, O.; Friese, M.; Mersmann, O.; Stork, J.; Simulation and Optimization of Cyclone Dust Separators Proceedings 23. Workshop Computational Intelligence, 2013, 177-196
}
