% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPAS.extract.par.est.R
\name{SPAS.extract.par.est}
\alias{SPAS.extract.par.est}
\title{Extract the estimates into a simpler form from a Stratified-Petersen fit}
\usage{
SPAS.extract.par.est(est.red, rowDM, colDM, thetaDM, conditional = TRUE)
}
\arguments{
\item{est.red}{Vector of parameter estimates}

\item{rowDM}{Design matrix for covariates for row parameters (after pooling). Not currently implemented so
this is usually an identity matrix.}

\item{colDM}{Design matrix for covariates for column parameters (after pooling). Not currently implemented so
this is usually an identity matrix.}

\item{thetaDM}{Design matrix for covariates for movement parameters (after pooling). Not currently implemented so
this is usually an identity matrix.}

\item{conditional}{Indicates if a conditional (poisson model) or full likelihood (multinomial) fit was done.}
}
\value{
Returns a list with entries 
\itemize{
  \item theta The modelled number of animals released in row stratum i and recovered in column stratum j.
  \item cap. The estimated probability of tagging in row stratum i.
  \item psi. The estimated number of animals never seen after tagging for each row stratum.
  \item N.   The estimated population size.
}
}
\description{
This function is normally used internally and not by users of the package.
}
\keyword{internal}
