% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SOAs_8level.R
\name{SOAs_8level}
\alias{SOAs_8level}
\title{Function to create 8-level SOAs according to Shi and Tang 2020}
\usage{
SOAs_8level(
  n,
  m = NULL,
  constr = "ShiTang_alphabeta",
  noptim.rounds = 1,
  noptim.repeats = 1,
  optimize = TRUE,
  dmethod = "manhattan",
  p = 50
)
}
\arguments{
\item{n}{run size of the SOA; power of 2, at least 16}

\item{m}{number of colums; at most 5\code{n}/16 for \code{constr="ShiTang_alpha"} (exception: only 9 for \code{n}=32),
at most \code{n/4} for \code{constr="ShiTang_alphabeta"}; for \code{m=NULL},
defaults are \code{m=5n/16} and \code{m=n/4-1}, respectively; the latter yields
strength 3+.}

\item{constr}{construction method.  Must be one of \code{"ShiTang_alphabeta", "ShiTang_alpha"}.
See Details section}

\item{noptim.rounds}{the number of optimization rounds for each independent restart}

\item{noptim.repeats}{the number of independent restarts of optimizations with \code{noptim.rounds} rounds each}

\item{optimize}{logical: should space filling be optimized by level permutations?}

\item{dmethod}{distance method for \code{\link{phi_p}}, "manhattan" (default) or "euclidean"}

\item{p}{p for \code{\link{phi_p}} (the larger, the closer to maximin distance)}
}
\value{
matrix of class \code{SOA} with the attributes that are listed below. All attributes can be accessed using function \code{\link{attributes}}, or individual attributes can be accessed using function \code{\link{attr}}. These are the attributes:
\describe{
\item{type}{the type of array (\code{SOA} or \code{OSOA})}
\item{strength}{character string that gives the strength}
\item{phi_p}{the phi_p value (smaller=better)}
\item{optimized}{logical indicating whether optimization was applied}
\item{permpick}{matrix that lists the id numbers of the permutations used}
\item{perms2pickfrom}{optional element, when optimization was conducted: the
overall permutation list to which the numbers in permlist refer}
\item{call}{the call that created the object}
}
}
\description{
creates strength 3 or 3+ SOAs with 8-level factors in 2^k runs, k at least 4.
These SOAs have at least some more balance than guaranteed by strength 3.
}
\details{
The construction is implemented as described in Groemping (2022a).

The 8-level SOAs created by this construction have strength 3 and at least
the additional property alpha, which means that all pairs of columns achieve
perfect 4x4 balance, if consecutive level pairs (01, 23, 45, 67) are collapsed.

The "ShiTang_alphabeta" construction additionally yields perfect 4x2x2 balance,
if one column is collapsed to 4 levels, while two further columns are collapsed
to 2 levels (0123 vs 4567). with m = n/4 columns, the "ShiTang_alphabeta"
construction has a single pair of correlated columns, all other columns are
uncorrelated, due to a modification of Shi and Tang's column allocation that was
proposed in Groemping (2022a).

For m <= n/4 - 1, the "ShiTang_alphabeta" construction also yields perfect balance for
8x2 projections in 2D (i.e. if one original column with another column collapsed
to two levels).
Thus, it yields all strength 4 properties in 2D and 3D, which is called
strength 3+. Furthermore, Groemping (2022a) proposed an improved choice of columns
for matrix C that implies orthogonal columns in this case.
}
\examples{
## use with optimization for actually using such designs
## n/4 - 1 = 7 columns, strength 3+
SOAs_8level(32, optimize=FALSE)

## n/4 = 8 columns, strength 3 with alpha and beta
SOAs_8level(32, m=8, optimize=FALSE)

## 9 columns (special case n=32), strength 3 with alpha
SOAs_8level(32, constr="ShiTang_alpha", optimize=FALSE)

## 5*n/16 = 5 columns, strength 3 with alpha
SOAs_8level(16, constr="ShiTang_alpha", optimize=FALSE)

}
\references{
For full detail, see \code{\link{SOAs-package}}.

Groemping (2022a)\cr
Shi and Tang (2020)\cr
Weng (2014)
}
\author{
Ulrike Groemping
}
