% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMMA_RH.R
\name{RH}
\alias{RH}
\alias{glamlasso_RH}
\alias{Rotate}
\alias{H}
\title{The Rotated H-transform of a 3d Array by a Matrix}
\usage{
RH(M, A)
}
\arguments{
\item{M}{a \eqn{n \times p_1} matrix.}

\item{A}{a 3d array of size \eqn{p_1 \times p_2 \times p_3}.}
}
\value{
A 3d array of size \eqn{p_2 \times p_3 \times n}.
}
\description{
This function is an implementation of the \eqn{\rho}-operator found in 
\cite{Currie et al 2006}. It forms the basis of the GLAM arithmetic.
}
\details{
For details see \cite{Currie et al 2006}. Note that this particular implementation 
is not used in the optimization routines underlying the glamlasso procedure.
}
\examples{

n1 <- 65; n2 <- 26; n3 <- 13; p1 <- 13; p2 <- 5; p3 <- 4

##marginal design matrices (Kronecker components)
X1 <- matrix(rnorm(n1 * p1), n1, p1) 
X2 <- matrix(rnorm(n2 * p2), n2, p2) 
X3 <- matrix(rnorm(n3 * p3), n3, p3) 

Beta <- array(rnorm(p1 * p2 * p3, 0, 1), c(p1 , p2, p3))
max(abs(c(RH(X3, RH(X2, RH(X1, Beta)))) - kronecker(X3, kronecker(X2, X1)) \%*\% c(Beta)))

}
\references{
Currie, I. D., M. Durban, and P. H. C. Eilers (2006). Generalized linear
array models with applications to multidimensional
smoothing. \emph{Journal of the Royal Statistical Society. Series B}. 68, 259-280.
}
\author{
Adam Lund
}
