% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-Evaluation.R
\name{SLOS}
\alias{SLOS}
\title{SLOS function}
\usage{
SLOS(data)
}
\arguments{
\item{data}{Data frame or matrix containing testing data}
}
\value{
Displays the funnel plot, returns the comparing plot as a ggplot object and the SLOS table.
}
\description{
This function is the core of the SLOS package. It generates the prediction for each unit, a funnel plot for the SLOS analysis and a plot comparing observed vs predicted SLOS. To access the funnel plot, run ems::plot(result$funnel_plot).
}
\examples{
\donttest{
# Load example data
data(SampledData)

# Call the SLOS function on your data
result <- SLOS(sampled_data)

# Access the comparison plot
result$plot_SLOS_obv_prev

# Access the predictions for each unit
result$df_unit_slos

# The funnel plot will be displayed automatically, and you can access it again by calling
plot(result$funnel_plot)
}

}
