% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDiagnostics.R
\name{plotDiagnostics}
\alias{plotDiagnostics}
\title{Plot results from diagnostics collected during model fitting}
\usage{
plotDiagnostics(
  object,
  ind = max(object$diagnostics$penalty),
  xvar = c("time", "iteration")
)
}
\arguments{
\item{object}{an object of class \code{"SLOPE"}.}

\item{ind}{either "last"}

\item{xvar}{what to place on the x axis. \code{iteration} plots each iteration,
\code{time} plots the wall-clock time.}
}
\value{
An object of class \code{"ggplot"}, which will be plotted on the
current device unless stored in a variable.
}
\description{
This function plots various diagnostics collected during
the model fitting resulting from a call to \code{\link[=SLOPE]{SLOPE()}} \emph{provided that
\code{diagnostics = TRUE}}.
}
\examples{
x <- SLOPE(abalone$x, abalone$y, diagnostics = TRUE)
plotDiagnostics(x)
}
\seealso{
\code{\link[=SLOPE]{SLOPE()}}, \code{\link[ggplot2:theme]{ggplot2::theme()}}
}
