% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{SLCA_predict}
\alias{SLCA_predict}
\title{Posterior prediction for model checking}
\usage{
SLCA_predict(alpha, beta, d, Z, mu_censor, gamma = 0)
}
\arguments{
\item{alpha}{estimated alpha - multinomial regression coefficients for latent class membership}

\item{beta}{estimated beta - class}

\item{d}{a vector of observed recurrent events for subjects of interest}

\item{Z}{a vector of time-independent corvariates}

\item{mu_censor}{a vector of estimated mu(C), where C is a vector of censoring time}

\item{gamma}{individual frailty. 0 represents the frailty equals 1 and k reprsents the frailty follows gamma(k,k)}
}
\value{
A list containing the following components:
\tabular{ll}{
   \code{PosteriorPredict} \tab A vector of posterior prediction for observed events for subjects of interest \cr
   \tab \cr
   \code{tauhat} \tab A matrix of posterior probability of latent class membership \cr
}
}
\description{
Predict numbers of recurrent events.
}
