% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.urarima.R
\name{sim.urarima}
\alias{sim.urarima}
\title{Generate Unit-root ARIMA Possibly Seasonal Time Series}
\usage{
sim.urarima(
  T = 300,
  ar = c(0.5),
  ma = c(-0.5),
  d = 1,
  sar = NULL,
  sma = NULL,
  D = 0,
  period = 12,
  ini = 200,
  df = 50
)
}
\arguments{
\item{T}{Number of observations.}

\item{ar}{Vector with the autoregressive coefficients. Default value is 0.5.}

\item{ma}{Vector with the moving average coefficients. Default value is -0.5.}

\item{d}{Order of first-differencing. Default value is 1.}

\item{sar}{Seasonal autoregressive coefficients. Default is NULL.}

\item{sma}{Seasonal moving average coefficients. Default is NULL.}

\item{D}{Order of seasonal differencing. Default value is 0.}

\item{period}{Seasonal period. Default value is 12.}

\item{ini}{Length of ‘burn-in’ period. Default value is 200.}

\item{df}{If df \eqn{\geq 50} random generation for the
Normal distribution, if df \eqn{< 50} random generation for the t distribution with df degrees
of freedom. Default value is 50.}
}
\value{
A time series vector.
}
\description{
Generate Unit-root ARIMA, possibly, seasonal time series.
}
\examples{
x <- sim.urarima()

}
