% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L1_Pop.R
\name{pullInd}
\alias{pullInd}
\title{Pull individuals from a population}
\usage{
pullInd(pop, nInd = NULL, use = "rand", simParamBee = NULL)
}
\arguments{
\item{pop}{\code{\link[AlphaSimR]{Pop-class}}}

\item{nInd}{numeric, number of individuals to pull, if \code{NULL} pull all
individuals}

\item{use}{character, all options provided by \code{\link[AlphaSimR]{selectInd}}}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
list with a node \code{pulled} holding \code{\link[AlphaSimR]{Pop-class}} of
  pulled individuals and a node \code{remnant)} holding \code{\link[AlphaSimR]{Pop-class}}
  of remaining individuals
}
\description{
Level 1 function that pulls individuals from a population and
  update the population (these individuals don't stay in a population).
}
\examples{
founderGenomes <- quickHaplo(nInd = 3, nChr = 1, segSites = 100)
SP <- SimParam$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- newPop(founderGenomes)

pullInd(basePop, nInd = 2)
pullInd(basePop, nInd = 3)
pullInd(basePop)
}
