% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{isVirginQueensPresent}
\alias{isVirginQueensPresent}
\alias{areVirginQueensPresent}
\title{Are virgin queen(s) present}
\usage{
isVirginQueensPresent(x)

areVirginQueensPresent(x)
}
\arguments{
\item{x}{\code{\link{Colony-class}} or \code{\link{MultiColony-class}}}
}
\value{
logical, named by colony id when \code{x} is
  \code{\link{MultiColony-class}}
}
\description{
Level 0 function that returns virgin queen(s) presence status.
}
\section{Functions}{
\itemize{
\item \code{areVirginQueensPresent()}: Are virgin queen(s) present

}}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- addVirginQueens(x = colony, nInd = 4)
isVirginQueensPresent(colony)
isVirginQueensPresent(pullVirginQueens(colony)$remnant)
isVirginQueensPresent(removeQueen(colony))

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 100, nDrones = 10)
isVirginQueensPresent(apiary)

tmp <- swarm(x = apiary)
isVirginQueensPresent(tmp$swarm)
isVirginQueensPresent(tmp$remnant)
}
