% Generated by roxygen2 (4.0.2): do not edit by hand
\name{resd}
\alias{resd}
\title{Root Expected Square Difference}
\usage{
resd(x, o, g, f, s)
}
\arguments{
\item{x}{a column vector of scores on which the rsd is conditioned}

\item{o}{a column vector of equated scores based on the overall population (aligned with elements in x)}

\item{g}{a column vector of equated scores based on a single subpopulation (aligned with elements in x)}

\item{f}{a column vector of relative frequency associated with each raw score (can be based on either overall population or a subpopulation) (aligned with elements in x)}

\item{s}{a scalar representing the standard deviation of x for any (sub)population of interest (e.g., synthetic population) (default is 1, which leads to calculation of the unstandardized resd)}
}
\value{
root expected square difference
}
\description{
The root expected square difference index (\eqn{RESD_j}{RESDj}) is a summary index of the weighted differences between a single subpopulation's equated scores, \eqn{y_j(x)}{y_j(x)}, and the equated scores based on the overall population, \eqn{y(x)}{y(x)}. Formally, 
\deqn{RESD_j=\frac{\sqrt{\sum_x P_x \{\lbrack y_j(x)-y(x)\rbrack^2\}}}{\sigma_x,}}{RESDj=sqrt(sum(P\{[y_j(x)-y(x)]^2\}))/s,}
where \eqn{x}{x} is a score on the original (i.e., unequated) scale, \eqn{P_x}{P} is the proportion of examinees scoring at \eqn{x}{x} and \eqn{\sigma_x}{s} is the standard deviation of x scores in the (sub)population of interest. It is considered a group-to-overall, unconditional index. It was originally presented by Yang (2004).  It provides practitioners with a summary of the magnitude of differences between a single subpopulation's equated scores and equated scores based on the overall population.
}
\examples{
#Unstandardized RESD for subpopulation 1 in the example data set, ex.data
resd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,3],f=ex.data[,8])

#Unstandardized RESD for subpopulation 5 in the example data set, ex.data
resd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,7],f=ex.data[,8])

#Standardized RESD for subpopulation 5 in the example data set, ex.data
resd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,7],f=ex.data[,8],s=4.2)
}
\author{
Anne Corinne Huggins-Manley
}
\references{
\itemize{
\item{Yang, W.L. (2004). Sensitivity of linkings between AP multiple-choice scores and composite scores to geographical region: An illustration of checking for population invariance. Journal of Educational Measurement, 41, 33-41.}
}
}
\seealso{
\code{\link{rsd}}
}

