% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygonArea.r
\name{polygonArea}
\alias{polygonArea}
\title{Polygon area}
\usage{
polygonArea(x)
}
\arguments{
\item{x}{A spatial object inheriting from \code{SpatialPolygons}}
}
\value{
Area of all polygons in \code{x}, taking account of holes. 
Units of area are squared units of coordinates in \code{x}.  E.g., 
square meters if coordinates in \code{x} are UTM meters, square
decimal degrees if coordinates in \code{x} are lat-long decimal 
degrees.
}
\description{
An all-R routine that computes area of all 
polygons in a \code{SpatialPolygons*} object, 
taking account of holes.
}
\details{
Provides the same answer as \code{rgeos::gArea}, but is 
all-R (does not require rgeos Java library) and does not 
fire a warning if \code{x} is un-projected (i.e., lat-long).
}
\examples{

# Area of Washington state, in hectares
a <- polygonArea( WA ) / (100*100)

}
\seealso{
\code{sp::SpatialPolygons-class}
}
\author{
Trent McDonald
}
