% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FuGePSD.R
\name{Pop.evaluate}
\alias{Pop.evaluate}
\title{Evaluates the entire population for the Global Fitness computation procedure.}
\usage{
Pop.evaluate(pop, dataset, examplesNoClass, exampleClass, frm, categorical,
  numerical, t_norm, weights)
}
\arguments{
\item{pop}{A list of 'Rule' objects.}

\item{dataset}{A 'keel' object with all the information of the dataset we are working}

\item{examplesNoClass}{Matrix with the data of the dataset, one colum per rule. The data must not contain the last column, the class. (use .separar for this task and convert the list into a matrix)}

\item{exampleClass}{Vector with the classes of all examples of the dataset}

\item{frm}{An integer specifing the tipo of fuzzy reasoning method to use. 0 for Winning Rule, 1 for Normalized Sum and 2 for Arithmetic Mean.}

\item{categorical}{A logical vector indicating which attributes of the dataset are categorical.}

\item{numerical}{A logical vector indicating which attributes of the dataset are numerical.}

\item{t_norm}{An integer specifying the t-norm to use. 0 for minimum t_norm, other value for product t-norm.}

\item{weights}{A numeric vector of length 4 indicating the weights used to calculate the global fitness of this population.}
}
\value{
A number which indicate the global fitness for this population.
}
\description{
Evaluates the entire population for the Global Fitness computation procedure.
}

