% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{reduce_dimensionality}
\alias{reduce_dimensionality}
\title{Dimensionality reduction}
\usage{
reduce_dimensionality(x, dist_fun, ndim = 3, landmark_method = c("naive",
  "none"), num_landmarks = 1000, rescale = T)
}
\arguments{
\item{x}{a numeric matrix}

\item{dist_fun}{the distance function to be used; must have exactly two arguments, namely dist_fun(x, y).}

\item{ndim}{the maximum dimension of the space which the data are to be represented in; must be in {1, 2, \ldots, n-1}.}

\item{landmark_method}{Must be "naive" for now. Other landmark methods will be supported in the future.}

\item{num_landmarks}{the number of landmarks to be selected.}

\item{rescale}{A logical indicating whether or not the returned space should be rescaled and centered.}
}
\value{
A matrix containing the coordinates of each sample, represented in an \code{ndim}-dimensional space.
}
\description{
\code{reduce_dimensionality} performs an eigenanalysis of the given dissimilarity matrix and returns coordinates of the samples represented in an \code{ndim}-dimensional space.
}
\examples{
## Generate an example dataset
dataset <- generate_dataset(type = "poly", num_genes = 500, num_samples = 1000, num_groups = 4)

## Reduce the dimensionality of this dataset
space <- reduce_dimensionality(dataset$expression, correlation_distance, ndim = 2)

## Visualise the dataset
draw_trajectory_plot(space, progression_group=dataset$sample_info$group_name)
}
\seealso{
\code{\link{correlation_distance}}, \code{\link{scale_uniform}}, \code{\link{draw_trajectory_plot}}
}
