#' Find the nearest neighbors
#'
#' @param fullcluster A list of clusters that generated by the function GetCluster().
#' @param normCount A list of normalized gene count matrix generated by the function NormData().
#' @param meaningn default to be 20
#'
#' @return A list of distance vectors
#' @export
#'
#' @examples
#' data(sim_result)
#' meaningn <- 20
#' FindNNDistC(sim_result[[1]], sim_result[[2]], meaningn = meaningn)


FindNNDistC <- function(fullcluster,normCount, meaningn = 20) {

  nclust <- rep(NA, length(fullcluster))

  for(i in seq_along(fullcluster)) {
    nclust[i] <- max(fullcluster[[i]]$finecluster)
  }

  dist_mat <- list()

  pb <- utils::txtProgressBar(min = 0,      # Minimum value of the progress bar
                              max = length(fullcluster), # Maximum value of the progress bar
                              style = 3,    # Progress bar style (also available style = 1 and style = 2)
                              width = 60,   # Progress bar width. Defaults to getOption("width")
                              char = "=")

  for(j in seq_along(fullcluster)) {
    utils::setTxtProgressBar(pb, j)
    #cat("j = ", j,"; ")

    onecount <- normCount[[j]]
    onemeta <- fullcluster[[j]]

    tmpvec <- c()
    newcounter = 1

    for(qqq in seq_along(fullcluster)) {
      if(qqq != j) {
        if(newcounter == 1) {
          othercount = normCount[[qqq]]
          newcounter = newcounter + 1
        } else {
          othercount = cbind(othercount, normCount[[qqq]])
        }
      }
    }


    allCT <- sort(unique(onemeta$finecluster))

    onep_internal = onep_external = list()

    for(q in seq_along(allCT)) {

      ct = allCT[q]

      onecdist_internal = onecdist_external <- list()

      max1 <- sum(onemeta$finecluster == ct)
      max2 <- sum(onemeta$finecluster != ct)

      subc <- onecount[, sample(which(onemeta$finecluster == ct), min(20, max1))]
      otherc <- onecount[, sample(which(onemeta$finecluster != ct), min(500, max2))]


      otherc_external <- as.matrix(othercount[,sample(1:ncol(othercount), min(500*length(normCount[-j]), ncol(othercount))) ])


      internal_distmat <- crossdist(t(as.matrix(otherc)),t(as.matrix(subc)))

      onecdist_internal <- apply(internal_distmat,2,sort)[1:meaningn,]

      external_distmat <- crossdist(t(as.matrix(otherc_external)),t(as.matrix(subc)))

      onecdist_external <- apply(external_distmat,2,sort)[1:meaningn,]


      onep_internal[[q]] <- as.list(data.frame(onecdist_internal))
      onep_external[[q]] <- as.list(data.frame(onecdist_external))

    }
    names(onep_internal) <- paste0("Cluster-",seq(1:length(allCT)),"-dist1")
    names(onep_external) <- paste0("Cluster-",seq(1:length(allCT)),"-dist2")

    dist_mat[[j]] <- list(onep_internal,onep_external)

  }
  close(pb)

  names(dist_mat) <- paste0("sample-",seq(1:length(fullcluster)))
  return(dist_mat)
}

