% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/vcgImport.r
\name{vcgImport}
\alias{vcgImport}
\title{Import common mesh file formats.}
\usage{
vcgImport(file, updateNormals = TRUE, readcolor = FALSE, clean = TRUE,
  silent = FALSE)
}
\arguments{
\item{file}{character: file to be read.}

\item{updateNormals}{logical: if TRUE and the imported file contais faces,
vertex normals will be (re)calculated. Otherwise, normals will be a matrix containing zeros.}

\item{readcolor}{if TRUE, vertex colors and texture (face and vertex) coordinates will be processed - if available, otherwise all vertices will be colored white.}

\item{clean}{if TRUE, duplicated and unreferenced vertices as well as duplicate faces are removed (be careful when importing point clouds).}

\item{silent}{logical, if TRUE no console output is issued.}
}
\value{
Object of class "mesh3d"

with:
\item{vb }{4 x n matrix containing n vertices as homolougous coordinates}
\item{it }{3 x m matrix containing vertex indices forming triangular faces}
\item{normals }{4 x n matrix containing vertex normals (homologous coordinates)}

in case the imported files contains face or vertex quality, these will be stored as vectors named $quality (for vertex quality) and $facequality


if the imported file contains vertex colors and readcolor = TRUE, these will be saved in $material$color according to "mesh3d" specifications.
}
\description{
Import common mesh file formats and store the results in an object of
class "mesh3d" - momentarily only triangular meshes are supported.
}
\note{
currently only meshes with either color or texture can be processed. If both are present, the function will mark the mesh as non-readable.
}
\examples{
data(humface)
vcgPlyWrite(humface)
readit <- vcgImport("humface.ply")
}
\author{
Stefan Schlager
}
\seealso{
\code{\link{vcgSmooth}}
}
\keyword{~kwd1}
\keyword{~kwd2}

