% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{tsEvaComputeTimeRP}
\alias{tsEvaComputeTimeRP}
\title{tsEvaComputeTimeRP}
\usage{
tsEvaComputeTimeRP(params, RPiGEV, RPiGPD)
}
\arguments{
\item{params}{A data frame containing the following parameters:
\describe{
\item{\code{epsilonGEV}}{Shape parameter for the Generalized Extreme Value
(GEV) distribution.}
\item{\code{muGEV}}{Location parameter for the GEV distribution.}
\item{\code{sigmaGEV}}{Scale parameter for the GEV distribution.}
\item{\code{epsilonGPD}}{Shape parameter for the Generalized Pareto
(GPD) distribution.}
\item{\code{thresholdGPD}}{Threshold parameter for the GPD distribution.}
\item{\code{sigmaGPD}}{Scale parameter for the GPD distribution.}
\item{\code{nPeaks}}{Number of peaks in the sample time horizon.}
\item{\code{SampleTimeHorizon}}{Total number of years in the data sample.}
}}

\item{RPiGEV}{Value of RP for the GEV distribution.}

\item{RPiGPD}{Value of RP for the GPD distribution.}
}
\value{
A vector with the calculated return period for GEV and GPD distributions.
}
\description{
\code{tsEvaComputeTimeRP}is a function that calculates the return period
of a given event for GEV and GPD distributions at a given time index.
}
\examples{
#Parameter vector:
params <- t(data.frame(epsilonGEV = 0.2, muGEV = 3, sigmaGEV = 1,
                  epsilonGPD = 0.2, thresholdGPD = 3, sigmaGPD = 1,
                  nPeaks = 70, SampleTimeHorizon = 70))

tsEvaComputeTimeRP(params, RPiGEV = 10, RPiGPD = 10)
}
