% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineAndUpdateVariables.R
\name{DefineStoxBioticTranslation}
\alias{DefineStoxBioticTranslation}
\title{Define StoxBioticData variables translation}
\usage{
DefineStoxBioticTranslation(
  processData,
  UseProcessData = FALSE,
  DefinitionMethod = c("Table", "ResourceFile"),
  Translation = data.table::data.table(),
  FileName
)
}
\arguments{
\item{processData}{The current data produced by a previous instance of the function.}

\item{UseProcessData}{Logical: If TRUE use the existing function output in the process.}

\item{DefinitionMethod}{Character: A string naming the method to use, one of "Table" for defining the \code{Translation}, and "ResourceFile" for reading the table from the file given by \code{FileName}.}

\item{Translation}{A table of the columns "VariableName", representing the variable to translate; "Value", giving the values to translate; and "NewValue", giving the values to translate to.}

\item{FileName}{The csv file holding a table with the three variables listed for \code{Translation}.}
}
\value{
A \code{\link{StoxBioticTranslation}} object.
}
\description{
This function defines the translation table used as input to \code{\link{TranslateStoxBiotic}} to translate values of one or more columns of \code{\link{StoxBioticData}} to new values given by a table or read from a CSV file.
}
