% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StoxExport.R
\name{writeICESDatras}
\alias{writeICESDatras}
\title{Write ICES DATRAS (NS-IBTS) format file}
\usage{
writeICESDatras(BioticData, addStationType = NA, save = TRUE)
}
\arguments{
\item{BioticData}{a \code{BioticData} object from an XML file with NMD biotic version 3 format.}

\item{addStationType}{additional StationType to be included. By default only fish stations with StationType == NA are included.}

\item{save}{an output file in collated CSV format will be created if this parameter is set to TRUE.}
}
\value{
List of data.table objects in the ICES DATRAS CSV format.
}
\description{
Given an \code{BioticData} object, this function will write an ICES DATRAS (NS-IBTS) file. Note that this function only supports
\code{BioticData} object that is created from reading an NMD biotic version 3 XML file.
}
