% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_correlation.R
\name{weighted.corr}
\alias{weighted.corr}
\title{Weighted Bivariate Correlation}
\usage{
weighted.corr(x, y, w, na.rm = TRUE)
}
\arguments{
\item{x}{(numeric vector) variable from where to get correlation}

\item{y}{(numeric vector) variable from where to get correlation}

\item{w}{(numeric vector) vector of weights}

\item{na.rm}{(bool) True: NAs be stripped before computation proceeds}
}
\value{
Pearson correlation coefficient
}
\description{
Compute weighted pearson correlation coefficient of two numeric vectors
}
\examples{
data(df_talis18) 

weighted.corr(x = df_talis18$T3STAKE, y = df_talis18$T3TEAM, w = df_talis18$TCHWGT)
}
