% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fitting.R
\name{fit_model}
\alias{fit_model}
\title{Fit probit model to choice data}
\usage{
fit_model(
  data,
  scale = "Sigma_1,1 := 1",
  R = 1000,
  B = R/2,
  Q = 1,
  print_progress = getOption("RprobitB_progress"),
  prior = NULL,
  latent_classes = NULL,
  seed = NULL,
  fixed_parameter = list()
)
}
\arguments{
\item{data}{An object of class \code{RprobitB_data}.}

\item{scale}{A character which determines the utility scale. It is of the form
\verb{<parameter> := <value>}, where \verb{<parameter>} is either the name of a fixed
effect or \verb{Sigma_<j>,<j>} for the \verb{<j>}th diagonal element of \code{Sigma}, and
\verb{<value>} is the value of the fixed parameter.}

\item{R}{The number of iterations of the Gibbs sampler.}

\item{B}{The length of the burn-in period, i.e. a non-negative number of samples to
be discarded.}

\item{Q}{The thinning factor for the Gibbs samples, i.e. only every \code{Q}th
sample is kept.}

\item{print_progress}{A boolean, determining whether to print the Gibbs sampler progress and the
estimated remaining computation time.}

\item{prior}{A named list of parameters for the prior distributions. See the documentation
of \code{\link{check_prior}} for details about which parameters can be
specified.}

\item{latent_classes}{Either \code{NULL} (for no latent classes) or a list of parameters specifying
the number of latent classes and their updating scheme:
\itemize{
\item \code{C}: The fixed number (greater or equal 1) of latent classes,
which is set to 1 per default. If either \code{weight_update = TRUE}
or \code{dp_update = TRUE} (i.e. if classes are updated), \code{C}
equals the initial number of latent classes.
\item \code{weight_update}: A boolean, set to \code{TRUE} to weight-based
update the latent classes. See ... for details.
\item \code{dp_update}: A boolean, set to \code{TRUE} to update the latent
classes based on a Dirichlet process. See ... for details.
\item \code{Cmax}: The maximum number of latent classes.
\item \code{buffer}: The number of iterations to wait before a next
weight-based update of the latent classes.
\item \code{epsmin}: The threshold weight (between 0 and 1) for removing
a latent class in the weight-based updating scheme.
\item \code{epsmax}: The threshold weight (between 0 and 1) for splitting
a latent class in the weight-based updating scheme.
\item \code{distmin}: The (non-negative) threshold in class mean difference
for joining two latent classes in the weight-based updating scheme.
}}

\item{seed}{Set a seed for the Gibbs sampling.}

\item{fixed_parameter}{Optionally specify a named list with fixed parameter values for \code{alpha},
\code{C}, \code{s}, \code{b}, \code{Omega}, \code{Sigma}, \code{Sigma_full},
\code{beta}, \code{z}, or \code{d} for the simulation.
See \href{https://loelschlaeger.de/RprobitB/articles/v01_model_definition.html}{the vignette on model definition}
for definitions of these variables.}
}
\value{
An object of class \code{RprobitB_fit}.
}
\description{
This function performs Markov chain Monte Carlo simulation for fitting
different types of probit models (binary, multivariate, mixed, latent class,
ordered, ranked) to discrete choice data.
}
\details{
See \href{https://loelschlaeger.de/RprobitB/articles/v03_model_fitting.html}{the vignette on model fitting}
for more details.
}
\examples{
data <- simulate_choices(
  form = choice ~ var | 0, N = 100, T = 10, J = 3, seed = 1
)
model <- fit_model(data = data, R = 1000, seed = 1)
summary(model)

}
\seealso{
\itemize{
\item \code{\link[=prepare_data]{prepare_data()}} and \code{\link[=simulate_choices]{simulate_choices()}} for building an
\code{RprobitB_data} object
\item \code{\link[=update]{update()}} for estimating nested models
\item \code{\link[=transform]{transform()}} for transforming a fitted model
}
}
