% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{create_labels_Sigma}
\alias{create_labels_Sigma}
\title{Create labels for \code{Sigma}}
\usage{
create_labels_Sigma(J, cov_sym, ordered = FALSE)
}
\arguments{
\item{J}{The number (greater or equal 2) of choice alternatives.}

\item{cov_sym}{Set to \code{TRUE} for labels of symmetric covariance elements.}

\item{ordered}{A boolean, \code{FALSE} per default. If \code{TRUE}, the choice set
\code{alternatives} is assumed to be ordered from worst to best.}
}
\value{
A vector of labels for the model parameter \code{Sigma} of length
\code{(J-1)^2} if \code{cov_sym = TRUE} or of length \code{J*(J-1)/2}
if \code{cov_sym = FALSE}.
If \code{ordered = TRUE}, \code{Sigma} has only one element.
}
\description{
This function creates labels for the model parameter \code{Sigma}.
}
\details{
The labels are of the form \code{"j1,j2"}, where \code{j1,j2} are indices
of the two alternatives \code{j1} and \code{j2}.
}
\examples{
RprobitB:::create_labels_Sigma(3, cov_sym = TRUE)
RprobitB:::create_labels_Sigma(4, cov_sym = FALSE)
RprobitB:::create_labels_Sigma(4, ordered = TRUE)
}
\keyword{internal}
