% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_management.R
\name{RprobitB_data}
\alias{RprobitB_data}
\title{Create object of class \code{RprobitB_data}}
\usage{
RprobitB_data(
  data,
  choice_data,
  N,
  T,
  J,
  P_f,
  P_r,
  alternatives,
  ordered,
  ranked,
  base,
  form,
  re,
  ASC,
  effects,
  standardize,
  simulated,
  choice_available,
  true_parameter,
  res_var_names
)
}
\arguments{
\item{data}{A list with the choice data.
The list has \code{N} elements.
Each element is a list with two elements, \code{X} and \code{y}, which are
the covariates and decisions for a decision maker. More precisely,
\code{X} is a list of \code{T} elements, where each element is a matrix of
dimension \code{J}x(\code{P_f}+\code{P_r}) and contains the characteristics
for one choice occasion.
\code{y} is a vector of length \code{T} and contains the labels for the
chosen alternatives.}

\item{choice_data}{A \code{data.frame} of choice data in wide format, i.e. each row represents
one choice occasion.}

\item{N}{The number (greater or equal 1) of decision makers.}

\item{T}{The number (greater or equal 1) of choice occasions or a vector of choice
occasions of length \code{N} (i.e. a decision maker specific number).
Per default, \code{T = 1}.}

\item{J}{The number (greater or equal 2) of choice alternatives.}

\item{P_f}{The number of covariates connected to a fixed coefficient (can be 0).}

\item{P_r}{The number of covariates connected to a random coefficient (can be 0).}

\item{alternatives}{A character vector with the names of the choice alternatives.
If not specified, the choice set is defined by the observed choices.
If \code{ordered = TRUE}, \code{alternatives} is assumed to be specified with
the alternatives ordered from worst to best.}

\item{ordered}{A boolean, \code{FALSE} per default. If \code{TRUE}, the choice set
\code{alternatives} is assumed to be ordered from worst to best.}

\item{ranked}{TBA}

\item{base}{A character, the name of the base alternative for covariates that are not
alternative specific (i.e. type 2 covariates and ASCs). Ignored and set to
\code{NULL} if the model has no alternative specific covariates (e.g. in the
ordered probit model).
Per default, \code{base} is the last element of \code{alternatives}.}

\item{form}{A \code{formula} object that is used to specify the model equation.
The structure is \code{choice ~ A | B | C}, where
\itemize{
\item \code{choice} is the name of the dependent variable (the choices),
\item \code{A} are names of alternative and choice situation specific
covariates with a coefficient that is constant across alternatives,
\item \code{B} are names of choice situation specific covariates with
alternative specific coefficients,
\item and \code{C} are names of alternative and choice situation specific
covariates with alternative specific coefficients.
}

Multiple covariates (of one type) are separated by a \code{+} sign.
By default, alternative specific constants (ASCs) are added to the model.
They can be removed by adding \code{+0} in the second spot.

In the ordered probit model (\code{ordered = TRUE}), the \code{formula}
object has the simple structure \code{choice ~ A}. ASCs are not estimated.}

\item{re}{A character (vector) of covariates of \code{form} with random effects.
If \code{re = NULL} (the default), there are no random effects.
To have random effects for the ASCs, include \code{"ASC"} in \code{re}.}

\item{ASC}{A boolean, determining whether the model has ASCs.}

\item{effects}{A data frame with the effect names and booleans indicating whether
they are connected to random effects.}

\item{standardize}{A character vector of names of covariates that get standardized.
Covariates of type 1 or 3 have to be addressed by
\code{<covariate>_<alternative>}.
If \code{standardize = "all"}, all covariates get standardized.}

\item{simulated}{A boolean, if \code{TRUE} then \code{data} is simulated, otherwise
\code{data} is empirical.}

\item{choice_available}{A boolean, if \code{TRUE} then \code{data} contains observed choices.}

\item{true_parameter}{An object of class \code{RprobitB_parameters}.}

\item{res_var_names}{A names list of reserved variable names in \code{choice_data}.}
}
\value{
An object of class \code{RprobitB_data} with the arguments of this function
as elements.
}
\description{
This function constructs an object of class \code{RprobitB_data}.
}
\keyword{internal}
