% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{pdb_subset}
\alias{pdb_subset}
\title{Subset a Padrino database object}
\usage{
pdb_subset(pdb, ipm_ids)
}
\arguments{
\item{pdb}{A Padrino database object.}

\item{ipm_ids}{The \code{ipm_id}'s to subset the database to.}
}
\value{
A new Padrino database object containing only the models specified in
\code{ipm_ids}.
}
\description{
Subset a Padrino database object
}
\details{
Currently, the only variable to subset with is the \code{ipm_id}.
Eventually, subsetting based on other variables will be possible with syntax
similar to \code{subset}. At the moment, users will need to create a vector
of \code{ipm_id}s based on searching and then pass that to subset. See
Examples
}
\examples{

\dontrun{

data(pdb)

poa_ind <- pdb$Metadata$ipm_id[pdb$Metadata$tax_family == "Poaceae"]

poa_db  <- pdb_subset(pdb, ipm_ids = poa_ind)

}

}
