% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/IOFunctions.R
\name{SF.read.DecisionTable}
\alias{SF.read.DecisionTable}
\title{Reading tabular data from files.}
\usage{
SF.read.DecisionTable(filename, decision.attr = NULL, indx.nominal = NULL,
  ...)
}
\arguments{
\item{filename}{a path with a file name.}

\item{decision.attr}{an integer indicating an index of the decision attribute. See \code{\link{SF.asDecisionTable}}.}

\item{indx.nominal}{an integer vector with indices of attributes which should be considered as nominal.
See \code{\link{SF.asDecisionTable}}.}

\item{...}{additional parameters which are passed to the \code{read.table} function. See \code{\link{read.table}}.}
}
\value{
An object of the \code{"DecisionTable"} class. See \code{\link{SF.asDecisionTable}}.
}
\description{
This function can be used to import data sets from files and then construct a \code{DecisionTable} object. It uses
\code{\link{read.table}} function from \code{base} R.
}
\details{
The data should be in a tabular format containing rows and columns, where every row represents
an object/instance, while columns represent attributes of the objects.
}
\examples{
#############################################################
## Example 1: data set saved in a file
#############################################################
## Let us assume we have the following data which has been already saved to the file "tes.dat"
data <- data.frame(c(0.12, 0.23, 0.24), c(1,3,2), c(10, 12, 18), c("a", "a", "b"), c(1, 1, 2))
\dontrun{write.table(data, file = "tes.dat", row.names = FALSE, col.names = FALSE,
                    fileEncoding ="")}

## Then we would generate decision table from tes.dat file.
## in this case, we want to define that second and third attributes are nominal and continuous,
## respectively.
\dontrun{decision.table <- SF.read.DecisionTable(filename = "tes.dat", decision.attr = 5,
                  indx.nominal = c(2, 5), sep= " ", col.names = c("v1", "v2", "v3", "v4", "o1"))}
}
\author{
Andrzej Janusz
}

