% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{robyn_response}
\alias{robyn_response}
\title{Response Function}
\usage{
robyn_response(
  InputCollect = NULL,
  OutputCollect = NULL,
  json_file = NULL,
  robyn_object = NULL,
  select_build = NULL,
  media_metric = NULL,
  select_model = NULL,
  metric_value = NULL,
  dt_hyppar = NULL,
  dt_coef = NULL,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{InputCollect}{List. Contains all input parameters for the model.
Required when \code{robyn_object} is not provided.}

\item{OutputCollect}{List. Containing all model result.
Required when \code{robyn_object} is not provided.}

\item{json_file}{Character. JSON file to import previously exported inputs
(needs \code{dt_input} and \code{dt_holidays} parameters too).}

\item{robyn_object}{Character or List. Path of the \code{Robyn.RDS} object
that contains all previous modeling information or the imported list.}

\item{select_build}{Integer. Default to the latest model build. \code{select_build = 0}
selects the initial model. \code{select_build = 1} selects the first refresh model.}

\item{media_metric}{A character. Selected media variable for the response.
Must be one value from paid_media_spends, paid_media_vars or organic_vars}

\item{select_model}{Character. A model \code{SolID}. When \code{robyn_object}
is provided, \code{select_model} defaults to the already selected \code{SolID}. When
\code{robyn_object} is not provided, \code{select_model} must be provided with
\code{InputCollect} and \code{OutputCollect}, and must be one of
\code{OutputCollect$allSolutions}.}

\item{metric_value}{Numeric. Desired metric value to return a response for.}

\item{dt_hyppar}{A data.frame. When \code{robyn_object} is not provided, use
\code{dt_hyppar = OutputCollect$resultHypParam}. It must be provided along
\code{select_model}, \code{dt_coef} and \code{InputCollect}.}

\item{dt_coef}{A data.frame. When \code{robyn_object} is not provided, use
\code{dt_coef = OutputCollect$xDecompAgg}. It must be provided along
\code{select_model}, \code{dt_hyppar} and \code{InputCollect}.}

\item{quiet}{Boolean. Keep messages off?}

\item{...}{Additional parameters passed to \code{robyn_outputs()}.}
}
\value{
List. Response value and plot. Class: \code{robyn_response}.
}
\description{
\code{robyn_response()} returns the response for a given
spend level of a given \code{paid_media_vars} from a selected model
result and selected model build (initial model, refresh model, etc.).
}
\examples{
\dontrun{
# Having InputCollect and OutputCollect objects

# Get marginal response (mResponse) and marginal ROI (mROI) for
# the next 1k on 80k for search_S
spend1 <- 80000
Response1 <- robyn_response(
  InputCollect = InputCollect,
  OutputCollect = OutputCollect,
  media_metric = "search_S",
  metric_value = spend1
)$response
# Get ROI for 80k
Response1 / spend1 # ROI for search 80k

# Get response for 81k
spend2 <- spend1 + 1000
Response2 <- robyn_response(
  InputCollect = InputCollect,
  OutputCollect = OutputCollect,
  media_metric = "search_S",
  metric_value = spend2
)$response

# Get ROI for 81k
Response2 / spend2 # ROI for search 81k
# Get marginal response (mResponse) for the next 1k on 80k
Response2 - Response1
# Get marginal ROI (mROI) for the next 1k on 80k
(Response2 - Response1) / (spend2 - spend1)

# Example of getting paid media exposure response curves
imps <- 1000000
response_imps <- robyn_response(
  InputCollect = InputCollect,
  OutputCollect = OutputCollect,
  media_metric = "facebook_I",
  metric_value = imps
)$response
response_per_1k_imps <- response_imps / imps * 1000
response_per_1k_imps

# Get response for 80k for search_S from the a certain model SolID
# in the current model output in the global environment
robyn_response(
  InputCollect = InputCollect,
  OutputCollect = OutputCollect,
  media_metric = "search_S",
  metric_value = 80000,
  dt_hyppar = OutputCollect$resultHypParam,
  dt_coef = OutputCollect$xDecompAgg
)
}
}
