% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiRobu.R
\name{covRobRocke}
\alias{covRobRocke}
\alias{RockeMulti}
\title{Rocke's robust multivariate location and scatter estimator}
\usage{
covRobRocke(X, initial = "K", maxsteps = 5, propmin = 2, qs = 2,
  maxit = 50, tol = 1e-04)
}
\arguments{
\item{X}{a data matrix with observations in rows.}

\item{initial}{A character indicating the initial estimator. Valid options are 'K' (default)
for the Pena-Prieto 'KSD' estimate, and 'mve' for the Minimum Volume Ellipsoid.}

\item{maxsteps}{Maximum number of steps for the line search section of the algorithm.}

\item{propmin}{Regulates the proportion of weights computed from the initial estimator that
will be different from zero. The number of observations with initial non-zero weights will
be at least p (the number of columns of X) times propmin.}

\item{qs}{Tuning paramater for Rocke's loss functions.}

\item{maxit}{Maximum number of iterations.}

\item{tol}{Tolerance to decide converngence.#'}
}
\value{
A list with class \dQuote{covRob} containing the following elements:
\item{mu}{The location estimate}
\item{V}{The scatter matrix estimate, scaled for consistency at the normal distribution}
\item{center}{The location estimate. Same as \code{mu} above.}
\item{cov}{The scatter matrix estimate, scaled for consistency at the normal distribution. Same as \code{V} above.}
\item{dista}{Robust Mahalanobis distances}
\item{w}{weights}
\item{gamma}{Final value of the constant gamma that regulates the efficiency}
}
\description{
This function computes Rocke's robust estimator for multivariate location and scatter.
}
\details{
This function computes Rocke's robust estimator for multivariate location and scatter.
}
\examples{
data(bus)
X0 <- as.matrix(bus)
X1 <- X0[,-9]
tmp <- covRobRocke(X1)
round(tmp$cov[1:10, 1:10], 3)
tmp$mu

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\author{
Ricardo Maronna, \email{rmaronna@retina.ar}
}
