\name{cutoff}
\alias{cutoff}
\alias{cutoff.sememp}
\alias{cutoff.chisq}

\title{Generating function(s) for class 'cutoff'}
\description{
  Generating function(s) for class \code{cutoff}.
}
\usage{
cutoff(name = "empirical", body.fct0,
       cutoff.quantile  = 0.95,
       norm = NormType(), QF, nsim = 100000)
cutoff.sememp()
cutoff.chisq()
}
\arguments{
  \item{name}{argument for name slot of \code{cutoff} object}
  \item{body.fct0}{a call generated by code wrapped to \code{substitute} resp. \code{quote};
  the body of the \code{fct} slot of the \code{cutoff} object}
  \item{cutoff.quantile}{numeric (in [0,1]); the corresponding slot value for the \code{cutoff} object}
  \item{norm}{an object of class \code{NormType} -- the norm/distance by which to produce
              the cutoff - value.}
  \item{nsim}{ integer: the sample size used for determining the quantiles
  of \eqn{(x^\tau Q x)^{1/2}}{x'Qx\^.5}  for \eqn{x} multivariate standard
  normal and \eqn{Q} a corresponding quadratic form}
  \item{QF}{ a quadratic (positive semidefinite, symmetric) matrix used
             as quadratic form }
}
\details{
\code{cutoff} generates a valid object of class \code{"cutoff"}.
As function slot \code{fct} may only have a formal argument \code{data},
the other arguments to determine the cutoff value, i.e. \code{norm}, \code{QF}, \code{nsim},
\code{cutoff.quantile}, \code{nsim} have to enter the scope of this
function by lexical scoping; now \code{cutoff.quantile}, \code{norm}, \code{QF}
are to be taken from the calling environment (not from the defining one),
so we have delay evaluation of the function body, which is why we assume
it to be given wrapped into \code{substitute}  resp. \code{quote}.
\code{body.fct0} is by default (i.e. if argument \code{body.fct0} is missing) set
to \code{quote(quantile(slot(norm,"fct")(data), cutoff.quantile))}, internally,
i.e.; to an empirical quantile of the corresponding norms.\cr

\code{cutoff.sememp()} is a helper function generating the theoretical (asymptotic)
quantile of (the square root of) a corresponding quadratic form, assuming multivariate
normality; to determine this quantile \code{nsim} simulations are used.\cr

\code{cutoff.chisq()} is a helper function generating the theoretical (asymptotic)
quantile of (the square root of) a (self-standardized) quadratic form, assuming multivariate
normality; i.e.; a corresponding quantile of a Chi-Square distribution.
}
\value{Object of class \code{"cutoff"}.}
\author{
  Peter Ruckdeschel \email{Peter.Ruckdeschel@itwm.fraunhofer.de}
  }
%\note{}
\seealso{\code{\link{cutoff-class}}, \code{\link{ddPlot}} }
\examples{
cutoff()
cutoff.sememp()
cutoff.chisq()
}
\keyword{hplot}
