\name{getresponses}
\alias{getresponses}
\alias{getallresponses}
\alias{print.sm_response}
\title{Get responses}
\description{Get responses for a survey}
\usage{
getresponses(respondents, survey,
             api_key = getOption('sm_api_key'),
             oauth_token = getOption('sm_oauth_token'), ...)

getallresponses(survey, api_key, oauth_token, wait = 0, ...)
}
\arguments{
\item{respondents}{A vector containing up to 100 respondent ID numbers, possibly returned by \code{\link{respondentlist}}.}
\item{survey}{A Survey Monkey survey ID number (or an object of class \dQuote{sm_survey} from which it can be extracted), possibly returned by \code{\link{surveylist}}.}
\item{api_key}{Your API key. By default, retrieved from \code{getOption('sm_api_key')}.}
\item{oauth_token}{Your OAuth 2.0 token, as generated by \code{\link{smlogin}}. By default, retrieved from \code{getOption('sm_oauth_token')}.}
\item{wait}{A time, in seconds, to wait between API calls. This can be used to throttle API request in order to avoid going over limits.}
\item{...}{Other arguments passed to \code{\link[httr]{POST}}.}
}
\details{Retrieves response data for requested respondents to a specified survey. \code{getresponses()} retrieves a list structure that can be further parsed using an \code{as.data.frame} method. \code{getallresponses()} returns a data.frame of all responses for a survey automatically using just the survey ID.

Note: Text responses returned are truncated after 32,768 characters.

Note: Surveys with over 500,000 responses are not available via the API currently.}
\value{
For \code{getresponses()}, a list (of class \code{sm_response_list}) containing one or more objects of class \code{sm_response}.

For \code{getallresponses()}, a data.frame.
}
\references{
\url{https://developer.surveymonkey.com/mashery/get_responses}
}
\author{Thomas J. Leeper}
%\note{}
%\seealso{}
\examples{
\dontrun{
smlogin()
s <- surveylist()
r <- respondentlist(s[[1]])

# get one response
getresponses(r[[1]], s[[1]])

# get all responses (up to 100)
g <- getresponses(r, s[[1]])
as.data.frame(g) # convert to data.frame
}
}
%\keyword{}
