% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbal_gas_forecast.R
\name{mbal_forecast_param_gas}
\alias{mbal_forecast_param_gas}
\title{A list object of class 'forecast_gas' for material balance analysis}
\usage{
mbal_forecast_param_gas(
  input_unit = "Field",
  output_unit = "Field",
  G = NULL,
  phi = NULL,
  swi = NULL,
  pd = NULL,
  p = NULL,
  pvt = NULL,
  cf = NULL,
  M = NULL,
  wf = NULL,
  rel_perm = NULL
)
}
\arguments{
\item{input_unit}{a unit system for parameters, only the character string 'Field' is accepted}

\item{output_unit}{a unit system for properties, only the character string 'Field' is accepted}

\item{G}{original gas in place, SCF.}

\item{phi}{reservoir porosity, a numeric fraction}

\item{swi}{initial water saturation in the reservoir, a numeric fraction}

\item{pd}{dew point pressure, a numeric value, psi}

\item{p}{reservoir pressure, a numeric vector, psi}

\item{pvt}{a data frame of PVT properties including pressure 'p' in 'psi', oil formation volume factor 'Bo' in 'bbl/stb', solution gas-oil ratio 'Rs' in 'scf/stb', oil viscosity 'muo' in 'cp', volatilized oil-gas ratio 'Rv' in 'stb/scf', gas formation volume factor 'Bg' in 'bbl/scf', gas viscosity 'mug' in 'cp', water formation volume factor 'Bw' in 'bbl/stb', and water viscosity 'muw' in 'cp'}

\item{cf}{formation compressibility, a numeric value or vector, 1/psi}

\item{M}{ratio of non-net-pay pore volume to the reservoir (net-pay) volume, a numeric fraction.}

\item{wf}{weight factor, a numeric vector of zeros and ones. A zero value excludes the entire row of reservoir history data at a particular time from the material balance analysis}

\item{rel_perm}{a data frame with four columns: gas saturation 'Sg', liquid saturation 'Sl', gas relative permeability 'Krg', and oil relative permeability 'Krog'}
}
\value{
a list of class ’forecast_gas’ with all the required parameters for the mbal_forecast_gas() S3 methods
}
\description{
Create an object of class 'forecast_gas'
}
\examples{
p_pvt <- c(3700, 3650, 3400, 3100, 2800, 2500, 2200, 1900, 1600, 1300, 1000,
700,  600, 400)
Bo <- c(10.057, 2.417, 2.192, 1.916, 1.736, 1.617, 1.504, 1.416, 1.326, 1.268,
1.205, 1.149, 1.131, 1.093)

Rv <- c(84.11765, 84.11765, 70.5, 56.2, 46.5, 39.5, 33.8, 29.9, 27.3, 25.5, 25.9,
28.3, 29.8, 33.5) / 1e6

Rs <- c(11566, 2378, 2010, 1569, 1272, 1067, 873, 719, 565, 461, 349, 249, 218,
141)

Bg <- c(0.87, 0.88, 0.92, 0.99, 1.08, 1.20, 1.35, 1.56, 1.85, 2.28, 2.95, 4.09,
4.68, 6.53) / 1000

cw <- 3e-6

Bwi <- 10.05

Bw <- Bwi * exp(cw * (p_pvt[1] - p_pvt))

muo <- c(0.0612, 0.062, 0.1338, 0.1826, 0.2354, 0.3001, 0.3764, 0.4781, 0.6041,
0.7746, 1.0295, 1.358, 1.855, 2.500)

mug <- c(0.0612, 0.062, 0.0554, 0.0436, 0.0368, 0.0308, 0.0261, 0.0222, 0.0191,
0.0166, 0.0148, 0.0135, 0.0125, 0.0115)

muw <- rep(0.25, length(p_pvt))

pvt_table <- data.frame(p = p_pvt, Bo = Bo, Rs = Rs, Rv = Rv, Bg = Bg, Bw = Bw,
 muo = muo, mug = mug, muw = muw)

rel_perm <- as.data.frame(Rrelperm::kr2p_gl(SWCON = 0.2, SOIRG = 0.15,
SORG = 0.15, SGCON = 0.05, SGCRIT = 0.05, KRGCL = 1, KROGCG = 1,
NG = 3.16, NOG = 2.74, NP = 101))

colnames(rel_perm) <- c("Sg", "Sl", "Krg", "Krog")

p <- c(3700, 3650, 3400, 3100, 2800, 2500, 2200, 1900, 1600, 1300, 1000, 700,
600)

wf <- rep(1, length.out = length(p))

forecast_lst <- mbal_forecast_param_gas(input_unit = "Field",
output_unit = "Field", G = 2.41e10, phi = 0.1, swi = 0.2, pd = 3650,
p = p, pvt = pvt_table, M = 0, cf = 2e-6, wf = wf,
rel_perm = rel_perm)

dplyr::glimpse(forecast_lst)
}
