% Generated by roxygen2 (4.1.0.9000): do not edit by hand
% Please edit documentation in R/getCompany.R
\name{getCompany}
\alias{getCompany}
\title{Retrieve Company Profile Information}
\usage{
getCompany(token, universal_name = NULL, email_domain = NULL,
  company_id = NULL)
}
\arguments{
\item{token}{Authorization token.}

\item{universal_name}{LinkedIn universal company name. This is the exact name seen at the end of the URL on the company page on linkedin.com.}

\item{email_domain}{The email domain used by the company.}

\item{company_id}{LinkedIn company ID.}
}
\value{
Returns company profile data, such as LinkedIn ID, name, universal-name, email-domains, company-type, ticker, website-url, industries, status, twitter handle, employee-count-range, specialties, locations, description, founded-year, and number of followers.

The output when specifying the \code{universal_name} or \code{company_id} will be in a list, whereas the output when specifying the \code{email_domain} will be a dataframe.
}
\description{
\code{getCompany} retrieves company profiles using a company Id, a universal name, or an email domain.
}
\details{
The 'universal name' needs to be the exact name seen at the end of the URL on the company page on linkedin.com.
}
\examples{
\dontrun{

company.name <- getCompany(token=in.auth, universal_name="Facebook")

company.email <- getCompany(token=in.auth, email_domain = "columbia.edu")

# Main Columbia Name:
company.id <- getCompany(token=in.auth, company_id = company.email$company_id[14])

}
}
\author{
Michael Piccirilli \email{michael.r.piccirilli@gmail.com}
}
\seealso{
\code{\link{searchCompanies}}
}

