// Generated by rstantools.  Do not edit by hand.

/*
    rstanarm is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanarm is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanarm.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_SGT_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'SGT', line 33, column 2 to column 21)",
                                                      " (in 'SGT', line 33, column 22 to column 37)",
                                                      " (in 'SGT', line 34, column 1 to column 36)",
                                                      " (in 'SGT', line 35, column 1 to column 21)",
                                                      " (in 'SGT', line 36, column 1 to column 29)",
                                                      " (in 'SGT', line 37, column 1 to column 30)",
                                                      " (in 'SGT', line 38, column 1 to column 27)",
                                                      " (in 'SGT', line 39, column 1 to column 28)",
                                                      " (in 'SGT', line 40, column 1 to column 37)",
                                                      " (in 'SGT', line 41, column 1 to column 16)",
                                                      " (in 'SGT', line 42, column 1 to column 36)",
                                                      " (in 'SGT', line 43, column 1 to column 31)",
                                                      " (in 'SGT', line 44, column 1 to column 30)",
                                                      " (in 'SGT', line 45, column 1 to column 27)",
                                                      " (in 'SGT', line 46, column 1 to column 34)",
                                                      " (in 'SGT', line 49, column 1 to column 56)",
                                                      " (in 'SGT', line 50, column 1 to column 22)",
                                                      " (in 'SGT', line 51, column 1 to column 23)",
                                                      " (in 'SGT', line 52, column 1 to column 27)",
                                                      " (in 'SGT', line 53, column 1 to column 13)",
                                                      " (in 'SGT', line 54, column 1 to column 27)",
                                                      " (in 'SGT', line 55, column 1 to column 38)",
                                                      " (in 'SGT', line 56, column 1 to column 19)",
                                                      " (in 'SGT', line 57, column 1 to column 12)",
                                                      " (in 'SGT', line 58, column 1 to column 16)",
                                                      " (in 'SGT', line 59, column 1 to column 16)",
                                                      " (in 'SGT', line 64, column 2 to column 21)",
                                                      " (in 'SGT', line 62, column 2 to column 33)",
                                                      " (in 'SGT', line 61, column 1 to line 64, column 21)",
                                                      " (in 'SGT', line 77, column 3 to column 19)",
                                                      " (in 'SGT', line 76, column 2 to line 77, column 19)",
                                                      " (in 'SGT', line 78, column 2 to column 21)",
                                                      " (in 'SGT', line 75, column 9 to line 79, column 2)",
                                                      " (in 'SGT', line 67, column 2 to column 12)",
                                                      " (in 'SGT', line 69, column 3 to column 32)",
                                                      " (in 'SGT', line 68, column 2 to line 69, column 32)",
                                                      " (in 'SGT', line 71, column 3 to column 42)",
                                                      " (in 'SGT', line 70, column 27 to line 73, column 3)",
                                                      " (in 'SGT', line 70, column 2 to line 73, column 3)",
                                                      " (in 'SGT', line 74, column 2 to column 26)",
                                                      " (in 'SGT', line 66, column 25 to line 75, column 2)",
                                                      " (in 'SGT', line 66, column 1 to line 79, column 2)",
                                                      " (in 'SGT', line 80, column 1 to column 22)",
                                                      " (in 'SGT', line 81, column 1 to column 25)",
                                                      " (in 'SGT', line 82, column 1 to column 25)",
                                                      " (in 'SGT', line 87, column 3 to column 26)",
                                                      " (in 'SGT', line 85, column 3 to column 38)",
                                                      " (in 'SGT', line 84, column 1 to line 87, column 26)",
                                                      " (in 'SGT', line 89, column 1 to column 68)",
                                                      " (in 'SGT', line 90, column 1 to column 18)",
                                                      " (in 'SGT', line 95, column 2 to column 22)",
                                                      " (in 'SGT', line 93, column 2 to column 13)",
                                                      " (in 'SGT', line 92, column 1 to line 95, column 22)",
                                                      " (in 'SGT', line 98, column 2 to column 22)",
                                                      " (in 'SGT', line 100, column 3 to column 33)",
                                                      " (in 'SGT', line 99, column 2 to line 100, column 33)",
                                                      " (in 'SGT', line 97, column 26 to line 101, column 2)",
                                                      " (in 'SGT', line 97, column 1 to line 101, column 2)",
                                                      " (in 'SGT', line 104, column 3 to column 71)",
                                                      " (in 'SGT', line 103, column 2 to line 104, column 71)",
                                                      " (in 'SGT', line 111, column 3 to column 78)",
                                                      " (in 'SGT', line 112, column 3 to column 50)",
                                                      " (in 'SGT', line 110, column 9 to line 113, column 3)",
                                                      " (in 'SGT', line 108, column 3 to column 61)",
                                                      " (in 'SGT', line 109, column 3 to column 30)",
                                                      " (in 'SGT', line 107, column 27 to line 110, column 3)",
                                                      " (in 'SGT', line 107, column 2 to line 113, column 3)",
                                                      " (in 'SGT', line 125, column 3 to column 48)",
                                                      " (in 'SGT', line 129, column 5 to column 59)",
                                                      " (in 'SGT', line 127, column 5 to column 16)",
                                                      " (in 'SGT', line 126, column 3 to line 129, column 59)",
                                                      " (in 'SGT', line 124, column 34 to line 130, column 3)",
                                                      " (in 'SGT', line 124, column 8 to line 130, column 3)",
                                                      " (in 'SGT', line 122, column 4 to column 55)",
                                                      " (in 'SGT', line 120, column 5 to column 48)",
                                                      " (in 'SGT', line 119, column 4 to line 122, column 55)",
                                                      " (in 'SGT', line 118, column 33 to line 123, column 3)",
                                                      " (in 'SGT', line 118, column 7 to line 130, column 3)",
                                                      " (in 'SGT', line 117, column 3 to column 46)",
                                                      " (in 'SGT', line 116, column 2 to line 130, column 3)",
                                                      " (in 'SGT', line 136, column 3 to column 72)",
                                                      " (in 'SGT', line 135, column 9 to line 137, column 3)",
                                                      " (in 'SGT', line 134, column 3 to column 52)",
                                                      " (in 'SGT', line 133, column 27 to line 135, column 3)",
                                                      " (in 'SGT', line 133, column 2 to line 137, column 3)",
                                                      " (in 'SGT', line 143, column 3 to column 33)",
                                                      " (in 'SGT', line 140, column 3 to column 35)",
                                                      " (in 'SGT', line 141, column 3 to column 88)",
                                                      " (in 'SGT', line 139, column 26 to line 142, column 3)",
                                                      " (in 'SGT', line 139, column 2 to line 143, column 33)",
                                                      " (in 'SGT', line 149, column 3 to column 26)",
                                                      " (in 'SGT', line 147, column 3 to column 87)",
                                                      " (in 'SGT', line 146, column 2 to line 149, column 26)",
                                                      " (in 'SGT', line 102, column 16 to line 150, column 2)",
                                                      " (in 'SGT', line 102, column 1 to line 150, column 2)",
                                                      " (in 'SGT', line 153, column 31 to column 32)",
                                                      " (in 'SGT', line 153, column 1 to column 35)",
                                                      " (in 'SGT', line 154, column 45 to column 54)",
                                                      " (in 'SGT', line 154, column 1 to column 57)",
                                                      " (in 'SGT', line 155, column 1 to column 34)",
                                                      " (in 'SGT', line 156, column 1 to column 54)",
                                                      " (in 'SGT', line 157, column 1 to column 20)",
                                                      " (in 'SGT', line 162, column 34 to column 35)",
                                                      " (in 'SGT', line 162, column 4 to column 38)",
                                                      " (in 'SGT', line 159, column 1 to line 162, column 38)",
                                                      " (in 'SGT', line 160, column 46 to column 47)",
                                                      " (in 'SGT', line 160, column 2 to column 50)",
                                                      " (in 'SGT', line 167, column 2 to column 25)",
                                                      " (in 'SGT', line 168, column 2 to column 27)",
                                                      " (in 'SGT', line 166, column 8 to line 169, column 2)",
                                                      " (in 'SGT', line 164, column 2 to column 37)",
                                                      " (in 'SGT', line 165, column 2 to column 38)",
                                                      " (in 'SGT', line 163, column 21 to line 166, column 2)",
                                                      " (in 'SGT', line 163, column 1 to line 169, column 2)",
                                                      " (in 'SGT', line 175, column 2 to column 54)",
                                                      " (in 'SGT', line 177, column 3 to column 35)",
                                                      " (in 'SGT', line 176, column 2 to line 177, column 35)",
                                                      " (in 'SGT', line 174, column 8 to line 178, column 2)",
                                                      " (in 'SGT', line 173, column 6 to column 31)",
                                                      " (in 'SGT', line 172, column 2 to line 173, column 31)",
                                                      " (in 'SGT', line 171, column 26 to line 174, column 2)",
                                                      " (in 'SGT', line 171, column 1 to line 178, column 2)",
                                                      " (in 'SGT', line 184, column 4 to column 80)",
                                                      " (in 'SGT', line 182, column 4 to column 71)",
                                                      " (in 'SGT', line 181, column 3 to line 184, column 80)",
                                                      " (in 'SGT', line 180, column 16 to line 185, column 2)",
                                                      " (in 'SGT', line 180, column 1 to line 185, column 2)",
                                                      " (in 'SGT', line 3, column 1 to column 26)",
                                                      " (in 'SGT', line 4, column 1 to column 59)",
                                                      " (in 'SGT', line 5, column 1 to column 25)",
                                                      " (in 'SGT', line 6, column 1 to column 20)",
                                                      " (in 'SGT', line 6, column 22 to column 41)",
                                                      " (in 'SGT', line 7, column 1 to column 25)",
                                                      " (in 'SGT', line 8, column 1 to column 22)",
                                                      " (in 'SGT', line 8, column 23 to column 44)",
                                                      " (in 'SGT', line 9, column 1 to column 28)",
                                                      " (in 'SGT', line 10, column 17 to column 18)",
                                                      " (in 'SGT', line 10, column 1 to column 22)",
                                                      " (in 'SGT', line 11, column 1 to column 31)",
                                                      " (in 'SGT', line 11, column 32 to column 61)",
                                                      " (in 'SGT', line 12, column 1 to column 32)",
                                                      " (in 'SGT', line 12, column 33 to column 63)",
                                                      " (in 'SGT', line 13, column 1 to column 37)",
                                                      " (in 'SGT', line 14, column 1 to column 39)",
                                                      " (in 'SGT', line 15, column 1 to column 41)",
                                                      " (in 'SGT', line 16, column 1 to column 40)",
                                                      " (in 'SGT', line 17, column 1 to column 40)",
                                                      " (in 'SGT', line 18, column 1 to column 16)",
                                                      " (in 'SGT', line 19, column 8 to column 9)",
                                                      " (in 'SGT', line 19, column 11 to column 12)",
                                                      " (in 'SGT', line 19, column 1 to column 19)",
                                                      " (in 'SGT', line 20, column 17 to column 18)",
                                                      " (in 'SGT', line 20, column 1 to column 34)",
                                                      " (in 'SGT', line 23, column 2 to column 42)",
                                                      " (in 'SGT', line 24, column 1 to column 51)",
                                                      " (in 'SGT', line 30, column 2 to column 21)",
                                                      " (in 'SGT', line 26, column 2 to column 45)",
                                                      " (in 'SGT', line 25, column 32 to line 28, column 2)",
                                                      " (in 'SGT', line 25, column 1 to line 30, column 21)",
                                                      " (in 'SGT', line 33, column 9 to column 10)",
                                                      " (in 'SGT', line 45, column 8 to column 19)",
                                                      " (in 'SGT', line 50, column 17 to column 18)",
                                                      " (in 'SGT', line 51, column 17 to column 18)",
                                                      " (in 'SGT', line 52, column 8 to column 23)",
                                                      " (in 'SGT', line 53, column 8 to column 9)",
                                                      " (in 'SGT', line 54, column 17 to column 18)",
                                                      " (in 'SGT', line 55, column 17 to column 18)"};
#include <stan_meta_header.hpp>
class model_SGT final : public model_base_crtp<model_SGT> {
private:
  int SEASONALITY;
  double SEASONALITY_F;
  double CAUCHY_SD;
  double MIN_POW_TREND;
  double MAX_POW_TREND;
  double MIN_SIGMA;
  double MIN_NU;
  double MAX_NU;
  int N;
  Eigen::Matrix<double, -1, 1> y;
  double POW_TREND_ALPHA;
  double POW_TREND_BETA;
  double POW_SEASON_ALPHA;
  double POW_SEASON_BETA;
  int USE_REGRESSION;
  int SEASONALITY_TYPE;
  int USE_SMOOTHED_ERROR;
  int NUM_OF_SEASON_INIT_CYCLES;
  int LEVEL_CALC_METHOD;
  int J;
  Eigen::Matrix<double, -1, -1> xreg;
  Eigen::Matrix<double, -1, 1> REG_CAUCHY_SD;
  double fractSeasonality;
  double reg0CauchySd;
  int s_1dim__;
 
public:
  ~model_SGT() { }
  
  inline std::string model_name() const final { return "model_SGT"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_SGT(stan::io::var_context& context__, unsigned int random_seed__ = 0,
            std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_SGT_namespace::model_SGT";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 128;
      context__.validate_dims("data initialization","SEASONALITY","int",
          context__.to_vec());
      SEASONALITY = std::numeric_limits<int>::min();
      
      current_statement__ = 128;
      SEASONALITY = context__.vals_i("SEASONALITY")[(1 - 1)];
      current_statement__ = 128;
      current_statement__ = 128;
      check_greater_or_equal(function__, "SEASONALITY", SEASONALITY, 2);
      current_statement__ = 129;
      context__.validate_dims("data initialization","SEASONALITY_F","double",
          context__.to_vec());
      SEASONALITY_F = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 129;
      SEASONALITY_F = context__.vals_r("SEASONALITY_F")[(1 - 1)];
      current_statement__ = 129;
      current_statement__ = 129;
      check_greater_or_equal(function__, "SEASONALITY_F", SEASONALITY_F,
                             SEASONALITY);
      current_statement__ = 129;
      current_statement__ = 129;
      check_less_or_equal(function__, "SEASONALITY_F", SEASONALITY_F,
                          (SEASONALITY + 1));
      current_statement__ = 130;
      context__.validate_dims("data initialization","CAUCHY_SD","double",
          context__.to_vec());
      CAUCHY_SD = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 130;
      CAUCHY_SD = context__.vals_r("CAUCHY_SD")[(1 - 1)];
      current_statement__ = 130;
      current_statement__ = 130;
      check_greater_or_equal(function__, "CAUCHY_SD", CAUCHY_SD, 0);
      current_statement__ = 131;
      context__.validate_dims("data initialization","MIN_POW_TREND","double",
          context__.to_vec());
      MIN_POW_TREND = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 131;
      MIN_POW_TREND = context__.vals_r("MIN_POW_TREND")[(1 - 1)];
      current_statement__ = 132;
      context__.validate_dims("data initialization","MAX_POW_TREND","double",
          context__.to_vec());
      MAX_POW_TREND = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 132;
      MAX_POW_TREND = context__.vals_r("MAX_POW_TREND")[(1 - 1)];
      current_statement__ = 133;
      context__.validate_dims("data initialization","MIN_SIGMA","double",
          context__.to_vec());
      MIN_SIGMA = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 133;
      MIN_SIGMA = context__.vals_r("MIN_SIGMA")[(1 - 1)];
      current_statement__ = 133;
      current_statement__ = 133;
      check_greater_or_equal(function__, "MIN_SIGMA", MIN_SIGMA, 0);
      current_statement__ = 134;
      context__.validate_dims("data initialization","MIN_NU","double",
          context__.to_vec());
      MIN_NU = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 134;
      MIN_NU = context__.vals_r("MIN_NU")[(1 - 1)];
      current_statement__ = 134;
      current_statement__ = 134;
      check_greater_or_equal(function__, "MIN_NU", MIN_NU, 1);
      current_statement__ = 135;
      context__.validate_dims("data initialization","MAX_NU","double",
          context__.to_vec());
      MAX_NU = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 135;
      MAX_NU = context__.vals_r("MAX_NU")[(1 - 1)];
      current_statement__ = 135;
      current_statement__ = 135;
      check_greater_or_equal(function__, "MAX_NU", MAX_NU, 1);
      current_statement__ = 136;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 136;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 136;
      current_statement__ = 136;
      check_greater_or_equal(function__, "N", N, (SEASONALITY + 1));
      current_statement__ = 137;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 138;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(N));
      y = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 138;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 138;
        pos__ = 1;
        current_statement__ = 138;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 138;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 138;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 138;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 138;
        current_statement__ = 138;
        check_greater_or_equal(function__, "y[sym1__]", y[(sym1__ - 1)], 0);}
      current_statement__ = 139;
      context__.validate_dims("data initialization","POW_TREND_ALPHA",
          "double",context__.to_vec());
      POW_TREND_ALPHA = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 139;
      POW_TREND_ALPHA = context__.vals_r("POW_TREND_ALPHA")[(1 - 1)];
      current_statement__ = 139;
      current_statement__ = 139;
      check_greater_or_equal(function__, "POW_TREND_ALPHA", POW_TREND_ALPHA,
                             0);
      current_statement__ = 140;
      context__.validate_dims("data initialization","POW_TREND_BETA",
          "double",context__.to_vec());
      POW_TREND_BETA = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 140;
      POW_TREND_BETA = context__.vals_r("POW_TREND_BETA")[(1 - 1)];
      current_statement__ = 140;
      current_statement__ = 140;
      check_greater_or_equal(function__, "POW_TREND_BETA", POW_TREND_BETA, 0);
      current_statement__ = 141;
      context__.validate_dims("data initialization","POW_SEASON_ALPHA",
          "double",context__.to_vec());
      POW_SEASON_ALPHA = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 141;
      POW_SEASON_ALPHA = context__.vals_r("POW_SEASON_ALPHA")[(1 - 1)];
      current_statement__ = 141;
      current_statement__ = 141;
      check_greater_or_equal(function__, "POW_SEASON_ALPHA",
                             POW_SEASON_ALPHA, 0);
      current_statement__ = 142;
      context__.validate_dims("data initialization","POW_SEASON_BETA",
          "double",context__.to_vec());
      POW_SEASON_BETA = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 142;
      POW_SEASON_BETA = context__.vals_r("POW_SEASON_BETA")[(1 - 1)];
      current_statement__ = 142;
      current_statement__ = 142;
      check_greater_or_equal(function__, "POW_SEASON_BETA", POW_SEASON_BETA,
                             0);
      current_statement__ = 143;
      context__.validate_dims("data initialization","USE_REGRESSION","int",
          context__.to_vec());
      USE_REGRESSION = std::numeric_limits<int>::min();
      
      current_statement__ = 143;
      USE_REGRESSION = context__.vals_i("USE_REGRESSION")[(1 - 1)];
      current_statement__ = 143;
      current_statement__ = 143;
      check_greater_or_equal(function__, "USE_REGRESSION", USE_REGRESSION, 0);
      current_statement__ = 143;
      current_statement__ = 143;
      check_less_or_equal(function__, "USE_REGRESSION", USE_REGRESSION, 1);
      current_statement__ = 144;
      context__.validate_dims("data initialization","SEASONALITY_TYPE","int",
          context__.to_vec());
      SEASONALITY_TYPE = std::numeric_limits<int>::min();
      
      current_statement__ = 144;
      SEASONALITY_TYPE = context__.vals_i("SEASONALITY_TYPE")[(1 - 1)];
      current_statement__ = 144;
      current_statement__ = 144;
      check_greater_or_equal(function__, "SEASONALITY_TYPE",
                             SEASONALITY_TYPE, 0);
      current_statement__ = 144;
      current_statement__ = 144;
      check_less_or_equal(function__, "SEASONALITY_TYPE", SEASONALITY_TYPE, 1);
      current_statement__ = 145;
      context__.validate_dims("data initialization","USE_SMOOTHED_ERROR",
          "int",context__.to_vec());
      USE_SMOOTHED_ERROR = std::numeric_limits<int>::min();
      
      current_statement__ = 145;
      USE_SMOOTHED_ERROR = context__.vals_i("USE_SMOOTHED_ERROR")[(1 - 1)];
      current_statement__ = 145;
      current_statement__ = 145;
      check_greater_or_equal(function__, "USE_SMOOTHED_ERROR",
                             USE_SMOOTHED_ERROR, 0);
      current_statement__ = 145;
      current_statement__ = 145;
      check_less_or_equal(function__, "USE_SMOOTHED_ERROR",
                          USE_SMOOTHED_ERROR, 1);
      current_statement__ = 146;
      context__.validate_dims("data initialization",
          "NUM_OF_SEASON_INIT_CYCLES","int",context__.to_vec());
      NUM_OF_SEASON_INIT_CYCLES = std::numeric_limits<int>::min();
      
      current_statement__ = 146;
      NUM_OF_SEASON_INIT_CYCLES = context__.vals_i("NUM_OF_SEASON_INIT_CYCLES")[
          (1 - 1)];
      current_statement__ = 146;
      current_statement__ = 146;
      check_greater_or_equal(function__, "NUM_OF_SEASON_INIT_CYCLES",
                             NUM_OF_SEASON_INIT_CYCLES, 0);
      current_statement__ = 147;
      context__.validate_dims("data initialization","LEVEL_CALC_METHOD",
          "int",context__.to_vec());
      LEVEL_CALC_METHOD = std::numeric_limits<int>::min();
      
      current_statement__ = 147;
      LEVEL_CALC_METHOD = context__.vals_i("LEVEL_CALC_METHOD")[(1 - 1)];
      current_statement__ = 147;
      current_statement__ = 147;
      check_greater_or_equal(function__, "LEVEL_CALC_METHOD",
                             LEVEL_CALC_METHOD, 0);
      current_statement__ = 147;
      current_statement__ = 147;
      check_less_or_equal(function__, "LEVEL_CALC_METHOD", LEVEL_CALC_METHOD,
                          3);
      current_statement__ = 148;
      context__.validate_dims("data initialization","J","int",
          context__.to_vec());
      J = std::numeric_limits<int>::min();
      
      current_statement__ = 148;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 148;
      current_statement__ = 148;
      check_greater_or_equal(function__, "J", J, 1);
      current_statement__ = 149;
      validate_non_negative_index("xreg", "N", N);
      current_statement__ = 150;
      validate_non_negative_index("xreg", "J", J);
      current_statement__ = 151;
      context__.validate_dims("data initialization","xreg","double",
          context__.to_vec(N, J));
      xreg = Eigen::Matrix<double, -1, -1>(N, J);
      stan::math::fill(xreg, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xreg_flat__;
        current_statement__ = 151;
        assign(xreg_flat__, nil_index_list(), context__.vals_r("xreg"),
          "assigning variable xreg_flat__");
        current_statement__ = 151;
        pos__ = 1;
        current_statement__ = 151;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 151;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 151;
            assign(xreg,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xreg_flat__[(pos__ - 1)], "assigning variable xreg");
            current_statement__ = 151;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 152;
      validate_non_negative_index("REG_CAUCHY_SD", "J", J);
      current_statement__ = 153;
      context__.validate_dims("data initialization","REG_CAUCHY_SD","double",
          context__.to_vec(J));
      REG_CAUCHY_SD = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(REG_CAUCHY_SD, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> REG_CAUCHY_SD_flat__;
        current_statement__ = 153;
        assign(REG_CAUCHY_SD_flat__, nil_index_list(),
          context__.vals_r("REG_CAUCHY_SD"),
          "assigning variable REG_CAUCHY_SD_flat__");
        current_statement__ = 153;
        pos__ = 1;
        current_statement__ = 153;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 153;
          assign(REG_CAUCHY_SD,
            cons_list(index_uni(sym1__), nil_index_list()),
            REG_CAUCHY_SD_flat__[(pos__ - 1)],
            "assigning variable REG_CAUCHY_SD");
          current_statement__ = 153;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 153;
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        current_statement__ = 153;
        current_statement__ = 153;
        check_greater_or_equal(function__, "REG_CAUCHY_SD[sym1__]",
                               REG_CAUCHY_SD[(sym1__ - 1)], 0);}
      current_statement__ = 154;
      fractSeasonality = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 155;
      reg0CauchySd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 155;
      reg0CauchySd = (mean(REG_CAUCHY_SD) * 10);
      current_statement__ = 159;
      if (logical_gt(SEASONALITY_F, SEASONALITY)) {
        current_statement__ = 157;
        fractSeasonality = (SEASONALITY_F - SEASONALITY);
      } else {
        current_statement__ = 156;
        fractSeasonality = 0;
      }
      current_statement__ = 154;
      current_statement__ = 154;
      check_greater_or_equal(function__, "fractSeasonality",
                             fractSeasonality, 0);
      current_statement__ = 154;
      current_statement__ = 154;
      check_less_or_equal(function__, "fractSeasonality", fractSeasonality, 1);
      current_statement__ = 155;
      current_statement__ = 155;
      check_greater_or_equal(function__, "reg0CauchySd", reg0CauchySd, 0);
      current_statement__ = 160;
      validate_non_negative_index("regCoef", "J", J);
      current_statement__ = 161;
      validate_non_negative_index("initS", "SEASONALITY", SEASONALITY);
      current_statement__ = 162;
      validate_non_negative_index("l", "N", N);
      current_statement__ = 163;
      validate_non_negative_index("l0", "N", N);
      current_statement__ = 164;
      s_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 164;
      s_1dim__ = ((N + SEASONALITY) + 1);
      current_statement__ = 164;
      validate_non_negative_index("s", "N + SEASONALITY + 1", s_1dim__);
      current_statement__ = 165;
      validate_non_negative_index("r", "N", N);
      current_statement__ = 166;
      validate_non_negative_index("expVal", "N", N);
      current_statement__ = 167;
      validate_non_negative_index("smoothedInnovSize", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += J;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += SEASONALITY;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_SGT_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> regCoef;
      regCoef = Eigen::Matrix<local_scalar_t__, -1, 1>(J);
      stan::math::fill(regCoef, DUMMY_VAR__);
      
      current_statement__ = 1;
      regCoef = in__.vector(J);
      local_scalar_t__ regOffset;
      regOffset = DUMMY_VAR__;
      
      current_statement__ = 2;
      regOffset = in__.scalar();
      local_scalar_t__ nu;
      nu = DUMMY_VAR__;
      
      current_statement__ = 3;
      nu = in__.scalar();
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        nu = stan::math::lub_constrain(nu, MIN_NU, MAX_NU, lp__);
      } else {
        current_statement__ = 3;
        nu = stan::math::lub_constrain(nu, MIN_NU, MAX_NU);
      }
      local_scalar_t__ sigma;
      sigma = DUMMY_VAR__;
      
      current_statement__ = 4;
      sigma = in__.scalar();
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        sigma = stan::math::lb_constrain(sigma, 0, lp__);
      } else {
        current_statement__ = 4;
        sigma = stan::math::lb_constrain(sigma, 0);
      }
      local_scalar_t__ levSm;
      levSm = DUMMY_VAR__;
      
      current_statement__ = 5;
      levSm = in__.scalar();
      current_statement__ = 5;
      if (jacobian__) {
        current_statement__ = 5;
        levSm = stan::math::lub_constrain(levSm, 0, 1, lp__);
      } else {
        current_statement__ = 5;
        levSm = stan::math::lub_constrain(levSm, 0, 1);
      }
      local_scalar_t__ llevSm;
      llevSm = DUMMY_VAR__;
      
      current_statement__ = 6;
      llevSm = in__.scalar();
      current_statement__ = 6;
      if (jacobian__) {
        current_statement__ = 6;
        llevSm = stan::math::lub_constrain(llevSm, 0, 1, lp__);
      } else {
        current_statement__ = 6;
        llevSm = stan::math::lub_constrain(llevSm, 0, 1);
      }
      local_scalar_t__ sSm;
      sSm = DUMMY_VAR__;
      
      current_statement__ = 7;
      sSm = in__.scalar();
      current_statement__ = 7;
      if (jacobian__) {
        current_statement__ = 7;
        sSm = stan::math::lub_constrain(sSm, 0, 1, lp__);
      } else {
        current_statement__ = 7;
        sSm = stan::math::lub_constrain(sSm, 0, 1);
      }
      local_scalar_t__ powx;
      powx = DUMMY_VAR__;
      
      current_statement__ = 8;
      powx = in__.scalar();
      current_statement__ = 8;
      if (jacobian__) {
        current_statement__ = 8;
        powx = stan::math::lub_constrain(powx, 0, 1, lp__);
      } else {
        current_statement__ = 8;
        powx = stan::math::lub_constrain(powx, 0, 1);
      }
      local_scalar_t__ powTrendBeta;
      powTrendBeta = DUMMY_VAR__;
      
      current_statement__ = 9;
      powTrendBeta = in__.scalar();
      current_statement__ = 9;
      if (jacobian__) {
        current_statement__ = 9;
        powTrendBeta = stan::math::lub_constrain(powTrendBeta, 0, 1, lp__);
      } else {
        current_statement__ = 9;
        powTrendBeta = stan::math::lub_constrain(powTrendBeta, 0, 1);
      }
      local_scalar_t__ coefTrend;
      coefTrend = DUMMY_VAR__;
      
      current_statement__ = 10;
      coefTrend = in__.scalar();
      local_scalar_t__ offsetSigma;
      offsetSigma = DUMMY_VAR__;
      
      current_statement__ = 11;
      offsetSigma = in__.scalar();
      current_statement__ = 11;
      if (jacobian__) {
        current_statement__ = 11;
        offsetSigma = stan::math::lb_constrain(offsetSigma, MIN_SIGMA, lp__);
      } else {
        current_statement__ = 11;
        offsetSigma = stan::math::lb_constrain(offsetSigma, MIN_SIGMA);
      }
      local_scalar_t__ innovSm;
      innovSm = DUMMY_VAR__;
      
      current_statement__ = 12;
      innovSm = in__.scalar();
      current_statement__ = 12;
      if (jacobian__) {
        current_statement__ = 12;
        innovSm = stan::math::lub_constrain(innovSm, 0, 1, lp__);
      } else {
        current_statement__ = 12;
        innovSm = stan::math::lub_constrain(innovSm, 0, 1);
      }
      local_scalar_t__ innovSizeInit;
      innovSizeInit = DUMMY_VAR__;
      
      current_statement__ = 13;
      innovSizeInit = in__.scalar();
      current_statement__ = 13;
      if (jacobian__) {
        current_statement__ = 13;
        innovSizeInit = stan::math::lb_constrain(innovSizeInit, 0, lp__);
      } else {
        current_statement__ = 13;
        innovSizeInit = stan::math::lb_constrain(innovSizeInit, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> initS;
      initS = Eigen::Matrix<local_scalar_t__, -1, 1>(SEASONALITY);
      stan::math::fill(initS, DUMMY_VAR__);
      
      current_statement__ = 14;
      initS = in__.vector(SEASONALITY);
      local_scalar_t__ powSeason;
      powSeason = DUMMY_VAR__;
      
      current_statement__ = 15;
      powSeason = in__.scalar();
      current_statement__ = 15;
      if (jacobian__) {
        current_statement__ = 15;
        powSeason = stan::math::lub_constrain(powSeason, 0, 1, lp__);
      } else {
        current_statement__ = 15;
        powSeason = stan::math::lub_constrain(powSeason, 0, 1);
      }
      local_scalar_t__ powTrend;
      powTrend = DUMMY_VAR__;
      
      Eigen::Matrix<local_scalar_t__, -1, 1> l;
      l = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(l, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> l0;
      l0 = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(l0, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> s;
      s = Eigen::Matrix<local_scalar_t__, -1, 1>(s_1dim__);
      stan::math::fill(s, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> r;
      r = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(r, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> expVal;
      expVal = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(expVal, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> smoothedInnovSize;
      smoothedInnovSize = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(smoothedInnovSize, DUMMY_VAR__);
      
      local_scalar_t__ seasonalityP;
      seasonalityP = DUMMY_VAR__;
      
      local_scalar_t__ sumsu;
      sumsu = DUMMY_VAR__;
      
      local_scalar_t__ newLevelP;
      newLevelP = DUMMY_VAR__;
      
      local_scalar_t__ movingSum;
      movingSum = DUMMY_VAR__;
      
      current_statement__ = 29;
      if (USE_REGRESSION) {
        current_statement__ = 28;
        assign(r, nil_index_list(), add(multiply(xreg, regCoef), regOffset),
          "assigning variable r");
      } else {
        current_statement__ = 27;
        assign(r, nil_index_list(), rep_vector(0, N), "assigning variable r");
      }
      current_statement__ = 42;
      if (logical_eq(SEASONALITY_TYPE, 0)) {
        current_statement__ = 34;
        sumsu = 0;
        current_statement__ = 36;
        for (int i = 1; i <= SEASONALITY; ++i) {
          current_statement__ = 35;
          sumsu = (sumsu + stan::math::exp(initS[(i - 1)]));}
        current_statement__ = 39;
        for (int i = 1; i <= SEASONALITY; ++i) {
          current_statement__ = 37;
          assign(s, cons_list(index_uni(i), nil_index_list()),
            ((stan::math::exp(initS[(i - 1)]) * SEASONALITY) / sumsu),
            "assigning variable s");}
        current_statement__ = 40;
        assign(l, cons_list(index_uni(1), nil_index_list()),
          ((y[(1 - 1)] - r[(1 - 1)]) / s[(1 - 1)]), "assigning variable l");
      } else {
        current_statement__ = 31;
        for (int i = 1; i <= SEASONALITY; ++i) {
          current_statement__ = 30;
          assign(s, cons_list(index_uni(i), nil_index_list()),
            initS[(i - 1)], "assigning variable s");}
        current_statement__ = 32;
        assign(l, cons_list(index_uni(1), nil_index_list()),
          (y[(1 - 1)] - r[(1 - 1)]), "assigning variable l");
      }
      current_statement__ = 43;
      assign(s,
        cons_list(index_uni(((N + SEASONALITY) + 1)), nil_index_list()), 1,
        "assigning variable s");
      current_statement__ = 44;
      assign(s, cons_list(index_uni((SEASONALITY + 1)), nil_index_list()),
        s[(1 - 1)], "assigning variable s");
      current_statement__ = 45;
      assign(s, cons_list(index_uni((SEASONALITY + 2)), nil_index_list()),
        s[(2 - 1)], "assigning variable s");
      current_statement__ = 48;
      if (USE_SMOOTHED_ERROR) {
        current_statement__ = 47;
        assign(smoothedInnovSize, cons_list(index_uni(1), nil_index_list()),
          innovSizeInit, "assigning variable smoothedInnovSize");
      } else {
        current_statement__ = 46;
        assign(smoothedInnovSize, cons_list(index_uni(1), nil_index_list()),
          1, "assigning variable smoothedInnovSize");
      }
      current_statement__ = 49;
      powTrend = (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) +
                   MIN_POW_TREND);
      current_statement__ = 50;
      assign(expVal, cons_list(index_uni(1), nil_index_list()), y[(1 - 1)],
        "assigning variable expVal");
      current_statement__ = 53;
      if (logical_eq(LEVEL_CALC_METHOD, 3)) {
        current_statement__ = 52;
        assign(l0, cons_list(index_uni(1), nil_index_list()), l[(1 - 1)],
          "assigning variable l0");
      } else {
        current_statement__ = 51;
        assign(l0, nil_index_list(), rep_vector(0, N),
          "assigning variable l0");
      }
      current_statement__ = 58;
      if (logical_gt(LEVEL_CALC_METHOD, 0)) {
        current_statement__ = 54;
        movingSum = (y[(1 - 1)] - r[(1 - 1)]);
        current_statement__ = 56;
        for (int t = 2; t <= SEASONALITY; ++t) {
          current_statement__ = 55;
          movingSum = ((movingSum + y[(t - 1)]) - r[(t - 1)]);}
      } 
      current_statement__ = 95;
      for (int t = 2; t <= N; ++t) {
        current_statement__ = 60;
        if ((primitive_value(logical_gt(LEVEL_CALC_METHOD, 0)) &&
            primitive_value(logical_gt(t, SEASONALITY)))) {
          current_statement__ = 59;
          movingSum = ((movingSum + (y[(t - 1)] - r[(t - 1)])) -
                        (y[((t - SEASONALITY) - 1)] -
                          r[((t - SEASONALITY) - 1)]));
        } 
        current_statement__ = 67;
        if (logical_eq(SEASONALITY_TYPE, 0)) {
          current_statement__ = 64;
          assign(expVal, cons_list(index_uni(t), nil_index_list()),
            (((l[((t - 1) - 1)] +
                (coefTrend * pow(l[((t - 1) - 1)], powTrend))) * s[(t - 1)])
              + r[(t - 1)]), "assigning variable expVal");
          current_statement__ = 65;
          newLevelP = ((y[(t - 1)] - r[(t - 1)]) / s[(t - 1)]);
        } else {
          current_statement__ = 61;
          assign(expVal, cons_list(index_uni(t), nil_index_list()),
            (((l[((t - 1) - 1)] +
                (coefTrend * pow(l[((t - 1) - 1)], powTrend))) +
               (s[(t - 1)] * pow(l[((t - 1) - 1)], powSeason))) + r[(t - 1)]),
            "assigning variable expVal");
          current_statement__ = 62;
          newLevelP = ((y[(t - 1)] - r[(t - 1)]) -
                        (s[(t - 1)] * pow(l[((t - 1) - 1)], powSeason)));
        }
        current_statement__ = 80;
        if (logical_eq(LEVEL_CALC_METHOD, 0)) {
          current_statement__ = 79;
          assign(l, cons_list(index_uni(t), nil_index_list()),
            ((levSm * newLevelP) + ((1 - levSm) * l[((t - 1) - 1)])),
            "assigning variable l");
        } else {
          current_statement__ = 78;
          if (logical_eq(LEVEL_CALC_METHOD, 2)) {
            current_statement__ = 76;
            if (logical_lte(t, SEASONALITY)) {
              current_statement__ = 75;
              assign(l, cons_list(index_uni(t), nil_index_list()),
                ((levSm * newLevelP) + ((1 - levSm) * l[((t - 1) - 1)])),
                "assigning variable l");
            } else {
              current_statement__ = 74;
              assign(l, cons_list(index_uni(t), nil_index_list()),
                (((levSm * movingSum) / SEASONALITY) +
                  ((1 - levSm) * l[((t - 1) - 1)])), "assigning variable l");
            }
          } else {
            current_statement__ = 73;
            if (logical_eq(LEVEL_CALC_METHOD, 3)) {
              current_statement__ = 68;
              assign(l0, cons_list(index_uni(t), nil_index_list()),
                ((levSm * newLevelP) + ((1 - levSm) * l0[((t - 1) - 1)])),
                "assigning variable l0");
              current_statement__ = 71;
              if (logical_lte(t, SEASONALITY)) {
                current_statement__ = 70;
                assign(l, cons_list(index_uni(t), nil_index_list()),
                  l0[(t - 1)], "assigning variable l");
              } else {
                current_statement__ = 69;
                assign(l, cons_list(index_uni(t), nil_index_list()),
                  ((llevSm * l0[(t - 1)]) +
                    (((1 - llevSm) * movingSum) / SEASONALITY)),
                  "assigning variable l");
              }
            } 
          }
        }
        current_statement__ = 85;
        if (logical_eq(SEASONALITY_TYPE, 0)) {
          current_statement__ = 83;
          seasonalityP = (((sSm * (y[(t - 1)] - r[(t - 1)])) / l[(t - 1)]) +
                           ((1 - sSm) * s[(t - 1)]));
        } else {
          current_statement__ = 81;
          seasonalityP = (((sSm * ((y[(t - 1)] - l[(t - 1)]) - r[(t - 1)])) /
                            pow(l[((t - 1) - 1)], powSeason)) +
                           ((1 - sSm) * s[(t - 1)]));
        }
        current_statement__ = 90;
        if (logical_gt(fractSeasonality, 0)) {
          current_statement__ = 87;
          assign(s,
            cons_list(index_uni(((t + SEASONALITY) + 1)), nil_index_list()),
            seasonalityP, "assigning variable s");
          current_statement__ = 88;
          assign(s,
            cons_list(index_uni((t + SEASONALITY)), nil_index_list()),
            ((fractSeasonality * s[((t + SEASONALITY) - 1)]) +
              ((1 - fractSeasonality) * seasonalityP)),
            "assigning variable s");
        } else {
          current_statement__ = 86;
          assign(s,
            cons_list(index_uni((t + SEASONALITY)), nil_index_list()),
            seasonalityP, "assigning variable s");
        }
        current_statement__ = 93;
        if (USE_SMOOTHED_ERROR) {
          current_statement__ = 92;
          assign(smoothedInnovSize,
            cons_list(index_uni(t), nil_index_list()),
            ((innovSm * stan::math::abs((y[(t - 1)] - expVal[(t - 1)]))) +
              ((1 - innovSm) * smoothedInnovSize[((t - 1) - 1)])),
            "assigning variable smoothedInnovSize");
        } else {
          current_statement__ = 91;
          assign(smoothedInnovSize,
            cons_list(index_uni(t), nil_index_list()), 1,
            "assigning variable smoothedInnovSize");
        }}
      current_statement__ = 16;
      current_statement__ = 16;
      check_greater_or_equal(function__, "powTrend", powTrend, MIN_POW_TREND);
      current_statement__ = 16;
      current_statement__ = 16;
      check_less_or_equal(function__, "powTrend", powTrend, MAX_POW_TREND);
      current_statement__ = 17;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 17;
        current_statement__ = 17;
        check_greater_or_equal(function__, "l[sym1__]", l[(sym1__ - 1)], 0);}
      current_statement__ = 18;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 18;
        current_statement__ = 18;
        check_greater_or_equal(function__, "l0[sym1__]", l0[(sym1__ - 1)], 0);
      }
      current_statement__ = 21;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 21;
        current_statement__ = 21;
        check_greater_or_equal(function__, "expVal[sym1__]",
                               expVal[(sym1__ - 1)], 0);}
      current_statement__ = 22;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 22;
        current_statement__ = 22;
        check_greater_or_equal(function__, "smoothedInnovSize[sym1__]",
                               smoothedInnovSize[(sym1__ - 1)], 0);}
      {
        current_statement__ = 96;
        if (logical_lt(sigma, 0)) {
          current_statement__ = 96;
          lp_accum__.add(stan::math::negative_infinity());
        } else {
          current_statement__ = 96;
          lp_accum__.add(-cauchy_ccdf_log(0, 0, CAUCHY_SD));
        }
        current_statement__ = 97;
        lp_accum__.add(cauchy_lpdf<propto__>(sigma, 0, CAUCHY_SD));
        current_statement__ = 98;
        if (logical_lt(offsetSigma, MIN_SIGMA)) {
          current_statement__ = 98;
          lp_accum__.add(stan::math::negative_infinity());
        } else {
          current_statement__ = 98;
          lp_accum__.add(-cauchy_ccdf_log(MIN_SIGMA, MIN_SIGMA, CAUCHY_SD));
        }
        current_statement__ = 99;
        lp_accum__.add(
          cauchy_lpdf<propto__>(offsetSigma, MIN_SIGMA, CAUCHY_SD));
        current_statement__ = 100;
        lp_accum__.add(cauchy_lpdf<propto__>(coefTrend, 0, CAUCHY_SD));
        current_statement__ = 101;
        lp_accum__.add(
          beta_lpdf<propto__>(powTrendBeta, POW_TREND_ALPHA, POW_TREND_BETA));
        current_statement__ = 102;
        lp_accum__.add(beta_lpdf<propto__>(levSm, 1, 2));
        current_statement__ = 105;
        if (USE_SMOOTHED_ERROR) {
          current_statement__ = 106;
          if (logical_lt(innovSizeInit, 0)) {
            current_statement__ = 106;
            lp_accum__.add(stan::math::negative_infinity());
          } else {
            current_statement__ = 106;
            lp_accum__.add(-cauchy_ccdf_log(0, (y[(1 - 1)] / 100), CAUCHY_SD));
          }
          current_statement__ = 107;
          lp_accum__.add(
            cauchy_lpdf<propto__>(innovSizeInit, (y[(1 - 1)] / 100),
              CAUCHY_SD));
        } else {
          current_statement__ = 103;
          if (logical_lt(innovSizeInit, 0)) {
            current_statement__ = 103;
            lp_accum__.add(stan::math::negative_infinity());
          } else {
            current_statement__ = 103;
            lp_accum__.add(-normal_ccdf_log(0, 0, 1));
          }
          current_statement__ = 104;
          lp_accum__.add(normal_lpdf<propto__>(innovSizeInit, 0, 1));
        }
        current_statement__ = 114;
        if (USE_REGRESSION) {
          current_statement__ = 111;
          lp_accum__.add(cauchy_lpdf<propto__>(regCoef, 0, REG_CAUCHY_SD));
          current_statement__ = 112;
          lp_accum__.add(cauchy_lpdf<propto__>(regOffset, 0, reg0CauchySd));
        } else {
          current_statement__ = 108;
          lp_accum__.add(normal_lpdf<propto__>(regCoef, 0, 1));
          current_statement__ = 109;
          lp_accum__.add(normal_lpdf<propto__>(regOffset, 0, 1));
        }
        current_statement__ = 122;
        if (logical_eq(SEASONALITY_TYPE, 0)) {
          current_statement__ = 120;
          for (int t = 1; t <= SEASONALITY; ++t) {
            current_statement__ = 119;
            lp_accum__.add(cauchy_lpdf<propto__>(initS[(t - 1)], 0, 4));}
        } else {
          current_statement__ = 115;
          lp_accum__.add(
            beta_lpdf<propto__>(powSeason, POW_SEASON_ALPHA, POW_SEASON_BETA));
          current_statement__ = 117;
          for (int t = 1; t <= SEASONALITY; ++t) {
            current_statement__ = 116;
            lp_accum__.add(
              cauchy_lpdf<propto__>(initS[(t - 1)], 0, (y[(t - 1)] * 0.3)));}
        }
        current_statement__ = 127;
        for (int t = 2; t <= N; ++t) {
          current_statement__ = 125;
          if (logical_eq(USE_SMOOTHED_ERROR, 0)) {
            current_statement__ = 124;
            lp_accum__.add(
              student_t_lpdf<propto__>(y[(t - 1)], nu, expVal[(t - 1)],
                ((sigma * pow(expVal[(t - 1)], powx)) + offsetSigma)));
          } else {
            current_statement__ = 123;
            lp_accum__.add(
              student_t_lpdf<propto__>(y[(t - 1)], nu, expVal[(t - 1)],
                ((sigma * smoothedInnovSize[((t - 1) - 1)]) + offsetSigma)));
          }}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_SGT_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> regCoef;
      regCoef = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(regCoef, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      regCoef = in__.vector(J);
      double regOffset;
      regOffset = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      regOffset = in__.scalar();
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      nu = in__.scalar();
      current_statement__ = 3;
      nu = stan::math::lub_constrain(nu, MIN_NU, MAX_NU);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma = in__.scalar();
      current_statement__ = 4;
      sigma = stan::math::lb_constrain(sigma, 0);
      double levSm;
      levSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      levSm = in__.scalar();
      current_statement__ = 5;
      levSm = stan::math::lub_constrain(levSm, 0, 1);
      double llevSm;
      llevSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      llevSm = in__.scalar();
      current_statement__ = 6;
      llevSm = stan::math::lub_constrain(llevSm, 0, 1);
      double sSm;
      sSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sSm = in__.scalar();
      current_statement__ = 7;
      sSm = stan::math::lub_constrain(sSm, 0, 1);
      double powx;
      powx = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      powx = in__.scalar();
      current_statement__ = 8;
      powx = stan::math::lub_constrain(powx, 0, 1);
      double powTrendBeta;
      powTrendBeta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      powTrendBeta = in__.scalar();
      current_statement__ = 9;
      powTrendBeta = stan::math::lub_constrain(powTrendBeta, 0, 1);
      double coefTrend;
      coefTrend = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      coefTrend = in__.scalar();
      double offsetSigma;
      offsetSigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 11;
      offsetSigma = in__.scalar();
      current_statement__ = 11;
      offsetSigma = stan::math::lb_constrain(offsetSigma, MIN_SIGMA);
      double innovSm;
      innovSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      innovSm = in__.scalar();
      current_statement__ = 12;
      innovSm = stan::math::lub_constrain(innovSm, 0, 1);
      double innovSizeInit;
      innovSizeInit = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 13;
      innovSizeInit = in__.scalar();
      current_statement__ = 13;
      innovSizeInit = stan::math::lb_constrain(innovSizeInit, 0);
      Eigen::Matrix<double, -1, 1> initS;
      initS = Eigen::Matrix<double, -1, 1>(SEASONALITY);
      stan::math::fill(initS, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 14;
      initS = in__.vector(SEASONALITY);
      double powSeason;
      powSeason = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 15;
      powSeason = in__.scalar();
      current_statement__ = 15;
      powSeason = stan::math::lub_constrain(powSeason, 0, 1);
      double powTrend;
      powTrend = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, 1> l;
      l = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(l, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> l0;
      l0 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(l0, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> s;
      s = Eigen::Matrix<double, -1, 1>(s_1dim__);
      stan::math::fill(s, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> r;
      r = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(r, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> expVal;
      expVal = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(expVal, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> smoothedInnovSize;
      smoothedInnovSize = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(smoothedInnovSize, std::numeric_limits<double>::quiet_NaN());
      
      double seasonalityP;
      seasonalityP = std::numeric_limits<double>::quiet_NaN();
      
      double sumsu;
      sumsu = std::numeric_limits<double>::quiet_NaN();
      
      double newLevelP;
      newLevelP = std::numeric_limits<double>::quiet_NaN();
      
      double movingSum;
      movingSum = std::numeric_limits<double>::quiet_NaN();
      
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        vars__.emplace_back(regCoef[(sym1__ - 1)]);}
      vars__.emplace_back(regOffset);
      vars__.emplace_back(nu);
      vars__.emplace_back(sigma);
      vars__.emplace_back(levSm);
      vars__.emplace_back(llevSm);
      vars__.emplace_back(sSm);
      vars__.emplace_back(powx);
      vars__.emplace_back(powTrendBeta);
      vars__.emplace_back(coefTrend);
      vars__.emplace_back(offsetSigma);
      vars__.emplace_back(innovSm);
      vars__.emplace_back(innovSizeInit);
      for (int sym1__ = 1; sym1__ <= SEASONALITY; ++sym1__) {
        vars__.emplace_back(initS[(sym1__ - 1)]);}
      vars__.emplace_back(powSeason);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 29;
      if (USE_REGRESSION) {
        current_statement__ = 28;
        assign(r, nil_index_list(), add(multiply(xreg, regCoef), regOffset),
          "assigning variable r");
      } else {
        current_statement__ = 27;
        assign(r, nil_index_list(), rep_vector(0, N), "assigning variable r");
      }
      current_statement__ = 42;
      if (logical_eq(SEASONALITY_TYPE, 0)) {
        current_statement__ = 34;
        sumsu = 0;
        current_statement__ = 36;
        for (int i = 1; i <= SEASONALITY; ++i) {
          current_statement__ = 35;
          sumsu = (sumsu + stan::math::exp(initS[(i - 1)]));}
        current_statement__ = 39;
        for (int i = 1; i <= SEASONALITY; ++i) {
          current_statement__ = 37;
          assign(s, cons_list(index_uni(i), nil_index_list()),
            ((stan::math::exp(initS[(i - 1)]) * SEASONALITY) / sumsu),
            "assigning variable s");}
        current_statement__ = 40;
        assign(l, cons_list(index_uni(1), nil_index_list()),
          ((y[(1 - 1)] - r[(1 - 1)]) / s[(1 - 1)]), "assigning variable l");
      } else {
        current_statement__ = 31;
        for (int i = 1; i <= SEASONALITY; ++i) {
          current_statement__ = 30;
          assign(s, cons_list(index_uni(i), nil_index_list()),
            initS[(i - 1)], "assigning variable s");}
        current_statement__ = 32;
        assign(l, cons_list(index_uni(1), nil_index_list()),
          (y[(1 - 1)] - r[(1 - 1)]), "assigning variable l");
      }
      current_statement__ = 43;
      assign(s,
        cons_list(index_uni(((N + SEASONALITY) + 1)), nil_index_list()), 1,
        "assigning variable s");
      current_statement__ = 44;
      assign(s, cons_list(index_uni((SEASONALITY + 1)), nil_index_list()),
        s[(1 - 1)], "assigning variable s");
      current_statement__ = 45;
      assign(s, cons_list(index_uni((SEASONALITY + 2)), nil_index_list()),
        s[(2 - 1)], "assigning variable s");
      current_statement__ = 48;
      if (USE_SMOOTHED_ERROR) {
        current_statement__ = 47;
        assign(smoothedInnovSize, cons_list(index_uni(1), nil_index_list()),
          innovSizeInit, "assigning variable smoothedInnovSize");
      } else {
        current_statement__ = 46;
        assign(smoothedInnovSize, cons_list(index_uni(1), nil_index_list()),
          1, "assigning variable smoothedInnovSize");
      }
      current_statement__ = 49;
      powTrend = (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) +
                   MIN_POW_TREND);
      current_statement__ = 50;
      assign(expVal, cons_list(index_uni(1), nil_index_list()), y[(1 - 1)],
        "assigning variable expVal");
      current_statement__ = 53;
      if (logical_eq(LEVEL_CALC_METHOD, 3)) {
        current_statement__ = 52;
        assign(l0, cons_list(index_uni(1), nil_index_list()), l[(1 - 1)],
          "assigning variable l0");
      } else {
        current_statement__ = 51;
        assign(l0, nil_index_list(), rep_vector(0, N),
          "assigning variable l0");
      }
      current_statement__ = 58;
      if (logical_gt(LEVEL_CALC_METHOD, 0)) {
        current_statement__ = 54;
        movingSum = (y[(1 - 1)] - r[(1 - 1)]);
        current_statement__ = 56;
        for (int t = 2; t <= SEASONALITY; ++t) {
          current_statement__ = 55;
          movingSum = ((movingSum + y[(t - 1)]) - r[(t - 1)]);}
      } 
      current_statement__ = 95;
      for (int t = 2; t <= N; ++t) {
        current_statement__ = 60;
        if ((primitive_value(logical_gt(LEVEL_CALC_METHOD, 0)) &&
            primitive_value(logical_gt(t, SEASONALITY)))) {
          current_statement__ = 59;
          movingSum = ((movingSum + (y[(t - 1)] - r[(t - 1)])) -
                        (y[((t - SEASONALITY) - 1)] -
                          r[((t - SEASONALITY) - 1)]));
        } 
        current_statement__ = 67;
        if (logical_eq(SEASONALITY_TYPE, 0)) {
          current_statement__ = 64;
          assign(expVal, cons_list(index_uni(t), nil_index_list()),
            (((l[((t - 1) - 1)] +
                (coefTrend * pow(l[((t - 1) - 1)], powTrend))) * s[(t - 1)])
              + r[(t - 1)]), "assigning variable expVal");
          current_statement__ = 65;
          newLevelP = ((y[(t - 1)] - r[(t - 1)]) / s[(t - 1)]);
        } else {
          current_statement__ = 61;
          assign(expVal, cons_list(index_uni(t), nil_index_list()),
            (((l[((t - 1) - 1)] +
                (coefTrend * pow(l[((t - 1) - 1)], powTrend))) +
               (s[(t - 1)] * pow(l[((t - 1) - 1)], powSeason))) + r[(t - 1)]),
            "assigning variable expVal");
          current_statement__ = 62;
          newLevelP = ((y[(t - 1)] - r[(t - 1)]) -
                        (s[(t - 1)] * pow(l[((t - 1) - 1)], powSeason)));
        }
        current_statement__ = 80;
        if (logical_eq(LEVEL_CALC_METHOD, 0)) {
          current_statement__ = 79;
          assign(l, cons_list(index_uni(t), nil_index_list()),
            ((levSm * newLevelP) + ((1 - levSm) * l[((t - 1) - 1)])),
            "assigning variable l");
        } else {
          current_statement__ = 78;
          if (logical_eq(LEVEL_CALC_METHOD, 2)) {
            current_statement__ = 76;
            if (logical_lte(t, SEASONALITY)) {
              current_statement__ = 75;
              assign(l, cons_list(index_uni(t), nil_index_list()),
                ((levSm * newLevelP) + ((1 - levSm) * l[((t - 1) - 1)])),
                "assigning variable l");
            } else {
              current_statement__ = 74;
              assign(l, cons_list(index_uni(t), nil_index_list()),
                (((levSm * movingSum) / SEASONALITY) +
                  ((1 - levSm) * l[((t - 1) - 1)])), "assigning variable l");
            }
          } else {
            current_statement__ = 73;
            if (logical_eq(LEVEL_CALC_METHOD, 3)) {
              current_statement__ = 68;
              assign(l0, cons_list(index_uni(t), nil_index_list()),
                ((levSm * newLevelP) + ((1 - levSm) * l0[((t - 1) - 1)])),
                "assigning variable l0");
              current_statement__ = 71;
              if (logical_lte(t, SEASONALITY)) {
                current_statement__ = 70;
                assign(l, cons_list(index_uni(t), nil_index_list()),
                  l0[(t - 1)], "assigning variable l");
              } else {
                current_statement__ = 69;
                assign(l, cons_list(index_uni(t), nil_index_list()),
                  ((llevSm * l0[(t - 1)]) +
                    (((1 - llevSm) * movingSum) / SEASONALITY)),
                  "assigning variable l");
              }
            } 
          }
        }
        current_statement__ = 85;
        if (logical_eq(SEASONALITY_TYPE, 0)) {
          current_statement__ = 83;
          seasonalityP = (((sSm * (y[(t - 1)] - r[(t - 1)])) / l[(t - 1)]) +
                           ((1 - sSm) * s[(t - 1)]));
        } else {
          current_statement__ = 81;
          seasonalityP = (((sSm * ((y[(t - 1)] - l[(t - 1)]) - r[(t - 1)])) /
                            pow(l[((t - 1) - 1)], powSeason)) +
                           ((1 - sSm) * s[(t - 1)]));
        }
        current_statement__ = 90;
        if (logical_gt(fractSeasonality, 0)) {
          current_statement__ = 87;
          assign(s,
            cons_list(index_uni(((t + SEASONALITY) + 1)), nil_index_list()),
            seasonalityP, "assigning variable s");
          current_statement__ = 88;
          assign(s,
            cons_list(index_uni((t + SEASONALITY)), nil_index_list()),
            ((fractSeasonality * s[((t + SEASONALITY) - 1)]) +
              ((1 - fractSeasonality) * seasonalityP)),
            "assigning variable s");
        } else {
          current_statement__ = 86;
          assign(s,
            cons_list(index_uni((t + SEASONALITY)), nil_index_list()),
            seasonalityP, "assigning variable s");
        }
        current_statement__ = 93;
        if (USE_SMOOTHED_ERROR) {
          current_statement__ = 92;
          assign(smoothedInnovSize,
            cons_list(index_uni(t), nil_index_list()),
            ((innovSm * stan::math::abs((y[(t - 1)] - expVal[(t - 1)]))) +
              ((1 - innovSm) * smoothedInnovSize[((t - 1) - 1)])),
            "assigning variable smoothedInnovSize");
        } else {
          current_statement__ = 91;
          assign(smoothedInnovSize,
            cons_list(index_uni(t), nil_index_list()), 1,
            "assigning variable smoothedInnovSize");
        }}
      current_statement__ = 16;
      current_statement__ = 16;
      check_greater_or_equal(function__, "powTrend", powTrend, MIN_POW_TREND);
      current_statement__ = 16;
      current_statement__ = 16;
      check_less_or_equal(function__, "powTrend", powTrend, MAX_POW_TREND);
      current_statement__ = 17;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 17;
        current_statement__ = 17;
        check_greater_or_equal(function__, "l[sym1__]", l[(sym1__ - 1)], 0);}
      current_statement__ = 18;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 18;
        current_statement__ = 18;
        check_greater_or_equal(function__, "l0[sym1__]", l0[(sym1__ - 1)], 0);
      }
      current_statement__ = 21;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 21;
        current_statement__ = 21;
        check_greater_or_equal(function__, "expVal[sym1__]",
                               expVal[(sym1__ - 1)], 0);}
      current_statement__ = 22;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 22;
        current_statement__ = 22;
        check_greater_or_equal(function__, "smoothedInnovSize[sym1__]",
                               smoothedInnovSize[(sym1__ - 1)], 0);}
      if (emit_transformed_parameters__) {
        vars__.emplace_back(powTrend);
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(l[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(l0[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= s_1dim__; ++sym1__) {
          vars__.emplace_back(s[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(r[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(expVal[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(smoothedInnovSize[(sym1__ - 1)]);}
        vars__.emplace_back(seasonalityP);
        vars__.emplace_back(sumsu);
        vars__.emplace_back(newLevelP);
        vars__.emplace_back(movingSum);
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> regCoef;
      regCoef = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(regCoef, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> regCoef_flat__;
        current_statement__ = 1;
        assign(regCoef_flat__, nil_index_list(), context__.vals_r("regCoef"),
          "assigning variable regCoef_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 1;
          assign(regCoef, cons_list(index_uni(sym1__), nil_index_list()),
            regCoef_flat__[(pos__ - 1)], "assigning variable regCoef");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      double regOffset;
      regOffset = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      regOffset = context__.vals_r("regOffset")[(1 - 1)];
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      nu = context__.vals_r("nu")[(1 - 1)];
      double nu_free__;
      nu_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      nu_free__ = stan::math::lub_free(nu, MIN_NU, MAX_NU);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      double sigma_free__;
      sigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma_free__ = stan::math::lb_free(sigma, 0);
      double levSm;
      levSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      levSm = context__.vals_r("levSm")[(1 - 1)];
      double levSm_free__;
      levSm_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      levSm_free__ = stan::math::lub_free(levSm, 0, 1);
      double llevSm;
      llevSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      llevSm = context__.vals_r("llevSm")[(1 - 1)];
      double llevSm_free__;
      llevSm_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      llevSm_free__ = stan::math::lub_free(llevSm, 0, 1);
      double sSm;
      sSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sSm = context__.vals_r("sSm")[(1 - 1)];
      double sSm_free__;
      sSm_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sSm_free__ = stan::math::lub_free(sSm, 0, 1);
      double powx;
      powx = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      powx = context__.vals_r("powx")[(1 - 1)];
      double powx_free__;
      powx_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      powx_free__ = stan::math::lub_free(powx, 0, 1);
      double powTrendBeta;
      powTrendBeta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      powTrendBeta = context__.vals_r("powTrendBeta")[(1 - 1)];
      double powTrendBeta_free__;
      powTrendBeta_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      powTrendBeta_free__ = stan::math::lub_free(powTrendBeta, 0, 1);
      double coefTrend;
      coefTrend = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      coefTrend = context__.vals_r("coefTrend")[(1 - 1)];
      double offsetSigma;
      offsetSigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 11;
      offsetSigma = context__.vals_r("offsetSigma")[(1 - 1)];
      double offsetSigma_free__;
      offsetSigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 11;
      offsetSigma_free__ = stan::math::lb_free(offsetSigma, MIN_SIGMA);
      double innovSm;
      innovSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      innovSm = context__.vals_r("innovSm")[(1 - 1)];
      double innovSm_free__;
      innovSm_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      innovSm_free__ = stan::math::lub_free(innovSm, 0, 1);
      double innovSizeInit;
      innovSizeInit = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 13;
      innovSizeInit = context__.vals_r("innovSizeInit")[(1 - 1)];
      double innovSizeInit_free__;
      innovSizeInit_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 13;
      innovSizeInit_free__ = stan::math::lb_free(innovSizeInit, 0);
      Eigen::Matrix<double, -1, 1> initS;
      initS = Eigen::Matrix<double, -1, 1>(SEASONALITY);
      stan::math::fill(initS, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> initS_flat__;
        current_statement__ = 14;
        assign(initS_flat__, nil_index_list(), context__.vals_r("initS"),
          "assigning variable initS_flat__");
        current_statement__ = 14;
        pos__ = 1;
        current_statement__ = 14;
        for (int sym1__ = 1; sym1__ <= SEASONALITY; ++sym1__) {
          current_statement__ = 14;
          assign(initS, cons_list(index_uni(sym1__), nil_index_list()),
            initS_flat__[(pos__ - 1)], "assigning variable initS");
          current_statement__ = 14;
          pos__ = (pos__ + 1);}
      }
      double powSeason;
      powSeason = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 15;
      powSeason = context__.vals_r("powSeason")[(1 - 1)];
      double powSeason_free__;
      powSeason_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 15;
      powSeason_free__ = stan::math::lub_free(powSeason, 0, 1);
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        vars__.emplace_back(regCoef[(sym1__ - 1)]);}
      vars__.emplace_back(regOffset);
      vars__.emplace_back(nu_free__);
      vars__.emplace_back(sigma_free__);
      vars__.emplace_back(levSm_free__);
      vars__.emplace_back(llevSm_free__);
      vars__.emplace_back(sSm_free__);
      vars__.emplace_back(powx_free__);
      vars__.emplace_back(powTrendBeta_free__);
      vars__.emplace_back(coefTrend);
      vars__.emplace_back(offsetSigma_free__);
      vars__.emplace_back(innovSm_free__);
      vars__.emplace_back(innovSizeInit_free__);
      for (int sym1__ = 1; sym1__ <= SEASONALITY; ++sym1__) {
        vars__.emplace_back(initS[(sym1__ - 1)]);}
      vars__.emplace_back(powSeason_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("regCoef");
    names__.emplace_back("regOffset");
    names__.emplace_back("nu");
    names__.emplace_back("sigma");
    names__.emplace_back("levSm");
    names__.emplace_back("llevSm");
    names__.emplace_back("sSm");
    names__.emplace_back("powx");
    names__.emplace_back("powTrendBeta");
    names__.emplace_back("coefTrend");
    names__.emplace_back("offsetSigma");
    names__.emplace_back("innovSm");
    names__.emplace_back("innovSizeInit");
    names__.emplace_back("initS");
    names__.emplace_back("powSeason");
    names__.emplace_back("powTrend");
    names__.emplace_back("l");
    names__.emplace_back("l0");
    names__.emplace_back("s");
    names__.emplace_back("r");
    names__.emplace_back("expVal");
    names__.emplace_back("smoothedInnovSize");
    names__.emplace_back("seasonalityP");
    names__.emplace_back("sumsu");
    names__.emplace_back("newLevelP");
    names__.emplace_back("movingSum");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(J)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(SEASONALITY)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(s_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "regCoef" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "regOffset");
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "sigma");
    param_names__.emplace_back(std::string() + "levSm");
    param_names__.emplace_back(std::string() + "llevSm");
    param_names__.emplace_back(std::string() + "sSm");
    param_names__.emplace_back(std::string() + "powx");
    param_names__.emplace_back(std::string() + "powTrendBeta");
    param_names__.emplace_back(std::string() + "coefTrend");
    param_names__.emplace_back(std::string() + "offsetSigma");
    param_names__.emplace_back(std::string() + "innovSm");
    param_names__.emplace_back(std::string() + "innovSizeInit");
    for (int sym1__ = 1; sym1__ <= SEASONALITY; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "initS" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "powSeason");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "powTrend");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "l" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "l0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= s_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "s" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "r" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "expVal" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "smoothedInnovSize" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "seasonalityP");
      param_names__.emplace_back(std::string() + "sumsu");
      param_names__.emplace_back(std::string() + "newLevelP");
      param_names__.emplace_back(std::string() + "movingSum");
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "regCoef" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "regOffset");
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "sigma");
    param_names__.emplace_back(std::string() + "levSm");
    param_names__.emplace_back(std::string() + "llevSm");
    param_names__.emplace_back(std::string() + "sSm");
    param_names__.emplace_back(std::string() + "powx");
    param_names__.emplace_back(std::string() + "powTrendBeta");
    param_names__.emplace_back(std::string() + "coefTrend");
    param_names__.emplace_back(std::string() + "offsetSigma");
    param_names__.emplace_back(std::string() + "innovSm");
    param_names__.emplace_back(std::string() + "innovSizeInit");
    for (int sym1__ = 1; sym1__ <= SEASONALITY; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "initS" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "powSeason");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "powTrend");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "l" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "l0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= s_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "s" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "r" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "expVal" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "smoothedInnovSize" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "seasonalityP");
      param_names__.emplace_back(std::string() + "sumsu");
      param_names__.emplace_back(std::string() + "newLevelP");
      param_names__.emplace_back(std::string() + "movingSum");
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"regCoef\",\"type\":{\"name\":\"vector\",\"length\":" << J << "},\"block\":\"parameters\"},{\"name\":\"regOffset\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"levSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"llevSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powx\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrendBeta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"coefTrend\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"offsetSigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSizeInit\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"initS\",\"type\":{\"name\":\"vector\",\"length\":" << SEASONALITY << "},\"block\":\"parameters\"},{\"name\":\"powSeason\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrend\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"l\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"l0\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"s\",\"type\":{\"name\":\"vector\",\"length\":" << s_1dim__ << "},\"block\":\"transformed_parameters\"},{\"name\":\"r\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"expVal\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"smoothedInnovSize\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"seasonalityP\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"sumsu\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"newLevelP\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"movingSum\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"regCoef\",\"type\":{\"name\":\"vector\",\"length\":" << J << "},\"block\":\"parameters\"},{\"name\":\"regOffset\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"levSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"llevSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powx\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrendBeta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"coefTrend\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"offsetSigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSizeInit\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"initS\",\"type\":{\"name\":\"vector\",\"length\":" << SEASONALITY << "},\"block\":\"parameters\"},{\"name\":\"powSeason\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrend\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"l\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"l0\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"s\",\"type\":{\"name\":\"vector\",\"length\":" << s_1dim__ << "},\"block\":\"transformed_parameters\"},{\"name\":\"r\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"expVal\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"smoothedInnovSize\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"seasonalityP\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"sumsu\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"newLevelP\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"movingSum\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_SGT_namespace::model_SGT;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_SGT_namespace::profiles__;
}
#endif
#endif
