% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_ilostat.R
\name{label_ilostat}
\alias{label_ilostat}
\title{Switch Ilostat codes and labels}
\usage{
label_ilostat(
  x,
  dic = NULL,
  code = NULL,
  lang = getOption("ilostat_lang", "en")
)
}
\arguments{
\item{x}{A character or a factor vector or a data_frame to labelled.}

\item{dic}{A string (vector) naming ilostat dictionary or dictionaries.
If \code{NULL} (default) dictionary names are taken from column names of 
the data_frame. A character or a factor vector or a data_frame to labelled,}

\item{code}{a vector of names of the column for which code columns
should be retained. Set to \code{"all"}, keep all the code.}

\item{lang}{a character, code for language. Available are \code{"en"} (default), 
\code{"fr"} and \code{"es"}. Can be set also with options(ilostat_lang = 'fr'),}
}
\value{
a vector or a data_frame. The suffix ".label" is added to code column names.
}
\description{
Gets definitions/labels for ilostat codes from ilostat dictionaries.
}
\details{
A character or a factor vector of codes returns a corresponding vector of definitions. 
  \code{label_ilostat} labels also data_frames from \code{\link{get_ilostat}}. For vectors a dictionary 
  "time" and "values" columns are returned as they were, so you can supply data_frame from \code{\link{get_ilostat}} 
  and get data_frame with definitions instead of codes.
}
\examples{
\dontrun{
 dat <- get_ilostat("UNE_2UNE_SEX_AGE_NB_A", cache = FALSE)
 dat_lab <- label_ilostat(dat)
 head(dat_lab)
 clean_ilostat_cache() 
}
}
\references{
See citation("Rilostat")
ilostat bulk download facility user guidelines 
\url{https://www.ilo.org/ilostat-files/Documents/ILOSTAT_BulkDownload_Guidelines.pdf}
}
\author{
David Bescond \email{bescond@ilo.org}
}
