% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_pdist.R
\name{gr.pdist}
\alias{gr.pdist}
\title{Pairwise Distance for Data on Grassmann Manifold}
\usage{
gr.pdist(
  input,
  type = c("Intrinsic", "Extrinsic", "Asimov", "Binet-Cauchy", "Chordal",
    "Fubini-Study", "Martin", "Procrustes", "Projection", "Spectral"),
  as.dist = TRUE,
  useR = FALSE
)
}
\arguments{
\item{input}{either an array of size \eqn{(n\times k\times N)} or a list of length \eqn{N} whose elements are \eqn{(n\times k)} orthonormal basis (ONB) on Grassmann manifold.}

\item{type}{type of distance measure. Name of each type is \emph{Case Insensitive} and \emph{hyphen} can be omitted.}

\item{as.dist}{a logical; \code{TRUE} to return a \code{\link[stats]{dist}} object or \code{FALSE} to return an \eqn{(N\times N)} symmetric matrix.}

\item{useR}{a logical; \code{TRUE} to use R computations while \code{FALSE} goes everything in C++.}
}
\value{
a \code{\link[stats]{dist}} object or \eqn{(N\times N)} symmetric matrix depending on \code{as.dist}.
}
\description{
For data on grassmann manifold \eqn{x_1,x_2,\ldots,x_N \in Gr(k,n)}, compute pairwise distances \eqn{d(x_i,x_j)} via several metrics. The distance type \code{"intrinsic"} corresponds to 
geodesic distance while \code{"extrinsic"} is equivalent to \code{"chordal"} distance.
}
\examples{
## generate a dataset with two types of Grassmann elements
#  group1 : first four columns of (8x8) identity matrix + noise
#  group2 : last  four columns of (8x8) identity matrix + noise

mydata = list()
sdval  = 0.25
diag8  = diag(8)
for (i in 1:10){
  mydata[[i]] = qr.Q(qr(diag8[,1:4] + matrix(rnorm(8*4,sd=sdval),ncol=4)))
}
for (i in 11:20){
  mydata[[i]] = qr.Q(qr(diag8[,5:8] + matrix(rnorm(8*4,sd=sdval),ncol=4)))
}

## try 'intrinsic' distance using C++ implementation
dmat = gr.pdist(mydata, type="intrinsic", as.dist=FALSE)
opar = par(no.readonly=TRUE)
par(pty="s")
image(dmat, main="intrinsic distance")
par(opar)

\donttest{
## compute and visualize distances for all types
#  we will iterate over all measures
alltypes = c("intrinsic","extrinsic","asimov","binet-cauchy",
"chordal","fubini-study","martin","procrustes","projection","spectral")
ntypes   = length(alltypes)

opar <- par(no.readonly=TRUE)
par(mfrow=c(2,5), pty="s")
for (i in 1:ntypes){
  dmat = gr.pdist(mydata, type=alltypes[i], as.dist=FALSE)
  image(dmat[,20:1], main=alltypes[i])
}
par(opar)
}

}
\author{
Kisung You
}
