% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rgff.R
\name{plot_features}
\alias{plot_features}
\title{Plots or exports an image of the feature tree from a GFF file}
\usage{
plot_features(
  inFile,
  outFile,
  includeCounts = FALSE,
  fileType = c("AUTO", "GFF3", "GTF"),
  exportFormat = c("png", "pdf", "svg")
)
}
\arguments{
\item{inFile}{Path to the input GFF file}

\item{outFile}{Path to the output features image file, if not provided the tree will be plotted}

\item{includeCounts}{Include number of occurrences of each subfeature}

\item{fileType}{Version of the input file (GTF/GFF3). If not provided it will be determined from the file name.}

\item{exportFormat}{Output image format when it is not possible to deduce it from the extension of outFile ("png", "pdf" or "svg"). Default, "png"}
}
\value{
Path of the output features image file
}
\description{
This function plots the feature tree from a GFF file or, if an output file name is provided,
exports an image of in the desired format ("png", "pdf" or "svg").
Packages "DiagrammeR", "DiagrammeRsvg" and "rsvg" must be installed to use this function.
}
\examples{
test_gff3<-system.file("extdata", "AthSmall.gff3", package="Rgff")
plot_features(test_gff3)
}
