% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_rf_lp.R
\name{compute_lp-forestry}
\alias{compute_lp-forestry}
\alias{compute_lp}
\title{compute lp distances}
\usage{
compute_lp(object, newdata, feature, p)
}
\arguments{
\item{object}{A `forestry` object.}

\item{newdata}{A data frame of test predictors.}

\item{feature}{A string denoting the dimension for computing lp distances.}

\item{p}{A positive real number determining the norm p-norm used.}
}
\value{
A vector of the lp distances.
}
\description{
Return the L_p norm distances of selected test observations
  relative to the training observations which the forest was trained on.
}
\examples{

# Set seed for reproductivity
set.seed(292313)

# Use Iris Data
test_idx <- sample(nrow(iris), 11)
x_train <- iris[-test_idx, -1]
y_train <- iris[-test_idx, 1]
x_test <- iris[test_idx, -1]

rf <- forestry(x = x_train, y = y_train,nthread = 2)
predict(rf, x_test)

# Compute the l2 distances in the "Petal.Length" dimension
distances_2 <- compute_lp(object = rf,
                          newdata = x_test,
                          feature = "Petal.Length",
                          p = 2)
}
