% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestry.R
\name{correctedPredict}
\alias{correctedPredict}
\title{correctedPredict-forestry}
\usage{
correctedPredict(
  object,
  newdata,
  feats = NULL,
  observations = NULL,
  nrounds = 0,
  linear = TRUE,
  binary = FALSE,
  aggregation = ifelse(object@OOBhonest, "doubleOOB", "oob"),
  verbose = FALSE,
  params.forestry = list(),
  keep_fits = FALSE
)
}
\arguments{
\item{object}{A `forestry` object.}

\item{newdata}{Dataframe on which to predict. If this is left NULL, we
predict on the in sample data.}

\item{feats}{A vector of feature indices which should be included in the bias
correction. By default only the outcome and predicted outcomes are used.}

\item{observations}{A vector of observation indices from the original data set
that should be used for the bias correction regression. This can be used for
treatment effect estimation to carry out separate regressions for the
treatment and control group.}

\item{nrounds}{The number of nonlinear bias correction steps which should be
taken. By default this is zero, so just a single linear correction is used.}

\item{linear}{A flag indicating whether or not we want to do a final linear
bias correction after doing the nonlinear corrections. Default is TRUE.}

\item{binary}{A flag indicating whether or not the linear correction should use
logistic regression for binary outcomes.}

\item{aggregation}{Gives the aggregation to use for the first round of predictions.}

\item{verbose}{flag which displays the bias of each qunatile.}

\item{params.forestry}{A list of parameters to pass to the subsequent forestry
calls. Note that these forests will be trained on features of dimension
length(feats) + 1 as the correction forests are trained on Y ~ cbind(newdata[,feats], Y.hat).
so monotonic constraints etc given to this list should be of size length(feats) + 1.
Defaults to the standard forestry parameters for any parameters that are
not included in the list.}

\item{keep_fits}{A flag that indicates if we should save the intermediate
forests used for the bias correction. If this is TRUE, we return a list of
the forestry objects for each iteration in the bias correction.}
}
\value{
A vector of the bias corrected predictions
}
\description{
Perform predictions given the forest using a bias correction based on
  the out of bag predictions on the training set. By default we use a final linear
  correction based on the leave-one-out hat matrix after doing `nrounds` nonlinear
  corrections.
}
\examples{
 library(Rforestry)
 set.seed(121235312)
 n <- 50
 p <- 10
 x <- matrix(rnorm(n * p), ncol = p)
 beta <- runif(p,min = 0, max = 1)
 y <- as.matrix(x) \%*\% beta + rnorm(50)
 x <- data.frame(x)

 forest <- forestry(x =x,
                    y = y[,1],
                    OOBhonest = TRUE,
                    doubleBootstrap = TRUE)
 p <- predict(forest, x)

 # Corrected predictions
 pred.bc <- correctedPredict(forest,
                             newdata = x,
                             nrounds = 0)

}
