% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_PostgreSQL_setup.R
\name{mod_postgres}
\alias{mod_postgres}
\alias{postgresql_setup_ui}
\alias{postgresql_setup_server}
\title{PostgreSQL Database Module}
\usage{
postgresql_setup_ui(id)

postgresql_setup_server(id)
}
\arguments{
\item{id}{The module namespace}
}
\value{
\emph{postgresql_setup_ui}:
\item{tagList}{The shinyPostgreSQL Setup UI}
\emph{postgresql_setup_server}:
\item{reactiveValues}{
\itemize{
\item{moduleName}: A string, containing the module moniker.
\item{moduleType}: A string, with the module type (what does it do?)
\item{setup_ui}: The module setup ui function
\item{is_connected}: A string, with module connection status. Valid statuses are
'yes' or 'no'.
\item{db_con}: A \link[DBI:dbConnect]{DBI::dbConnect} object, containing the user configured PostgreSQL
connection information.
}}
}
\description{
This module is designed to guide a user through the process of authenticating with
a PostgreSQL database. The user is visually prompted for typical PostgreSQL connection
parameters. User entered information is verified and once authenticated, a
\code{\link[DBI:dbConnect]{DBI::dbConnect()}} object is returned.

This module consists of the following components:
\subsection{Module UI function}{

\itemize{
\item{\code{postgresql_setup_ui}}: A uiOutput that allows users to connect to provide
connection parameters required to connect to a PostgreSQL database.
}
}

\subsection{Module Server function}{

\itemize{
\item{\code{postgresql_setup_server}}: The logic that controls the graphical user
interface, validates user inputs, and returns a \link[DBI:dbConnect]{DBI::dbconnect()} object
used to connect to the desired PostgreSQL database.
}
}
}
\keyword{internal}
