% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuthBackend.R
\name{AuthBackend}
\alias{AuthBackend}
\title{Create AuthBackend}
\description{
Creates AuthBackend class object.
}
\note{
This object is typically constructed via a derived classes, e.g.
\link{AuthBackendBasic} or \link{AuthBackendBearer}.
}
\references{
\href{https://github.com/vertexcover-io/falcon-auth}{falcon-auth}
}
\seealso{
Other AuthBackend: 
\code{\link{AuthBackendBasic}},
\code{\link{AuthBackendBearer}},
\code{\link{AuthMiddleware}}
}
\concept{AuthBackend}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{HTTPError}}{Class which raises HTTP errors.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AuthBackend$new()}}
\item \href{#method-authenticate}{\code{AuthBackend$authenticate()}}
\item \href{#method-clone}{\code{AuthBackend$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates AuthBackend class object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthBackend$new(FUN, auth_header_prefix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{FUN}}{Authentication handler function.}

\item{\code{auth_header_prefix}}{Authentication HTTP header prefix.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-authenticate"></a>}}
\if{latex}{\out{\hypertarget{method-authenticate}{}}}
\subsection{Method \code{authenticate()}}{
This placeholder. It must be implemented in the subclass.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthBackend$authenticate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthBackend$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
