% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Middleware.R
\docType{data}
\name{Middleware}
\alias{Middleware}
\title{Creates middleware object}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
Creates Middleware object.

Middleware is a very useful concept which allows to perform
preprocessing of requests and post-processing of responses. Middleware has
an access to both \code{request} and  \code{response} objects and can modify them.
This way each request can be checked/modified before passing handler and
response can be post processed (for example this way we developer can set up
custom error messages).
}
\section{Construction}{
\preformatted{Middleware$new(
  process_request  = function(request, response) TRUE,
  process_response = function(request, response) TRUE,
  id = "Middleware"
)
}
\itemize{
\item \code{process_request} :: \code{function}\cr
Modify \code{request} or \code{response} objects or  throw exception using
\code{[HTTPError]} helper. This function evaluate before router handler called.
\item \code{process_response} :: \code{function}\cr
Modify \code{request} or \code{response} objects or  throw exception using
\code{[HTTPError]} helper. This function evaluate after router handler called.
\item \code{id} :: \code{character(1)}\cr
Middleware id
}
}

\section{Fields}{

\itemize{
\item \code{process_request} :: \code{function}\cr
Function which takes 2 arguments - \code{request} and \code{response} objects (class
\link{Request} and \link{Response} correspondingly) and modify
\code{request} and \code{response} or throw exception using \link{HTTPError} helper.

Function is called before request is routed to handler.

Usually \code{process_request} is used to perform logging, check authorization, etc.
\item \code{process_response} :: \code{funciotn}\cr
Function which takes 2 arguments - \code{request} and \code{response} objects (class
\link{Request} and \link{Response} correspondingly) and modify
\code{request} and \code{response} or throw exception using \link{HTTPError} helper.

Function is called after request is processed by handler.

Usually \code{process_response} is used to perform logging, custom error handling, etc.
\item \code{id} :: \code{character(1)}\cr
Middleware id
}
}

\seealso{
\link{Request} \link{Response} \link{Application}
}
\keyword{datasets}
