% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Response.R
\docType{data}
\name{Response}
\alias{Response}
\title{Creates response object}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
Creates response object.
}
\section{Construction}{
\preformatted{Response$new(body = "",
             content_type = 'text/plain',
             headers = structure(list(), names = character(0)),
             status_code = 200L,
             encode = NULL)
}
}

\section{Fields}{

\itemize{
\item \strong{\code{content_type}} :: \code{character(1)}\cr
Response body content (media) type. Will be translated to \code{Content-type} header.
\item \strong{\code{body}} :: \code{raw()} | \code{character(1)}\cr
Response body.
If it is a named character with a name \code{file} or \code{tmpfile}
then the value is considered as a path to a file and content oh this file
is served as body. The latter will be deleted once served.
\item \strong{\code{status_code}} :: \code{integer(1)}\cr
Response status code.
\item \strong{\code{headers}} :: \code{named list()}\cr
Response headers.
\item \strong{\code{cookies}} :: \code{named list()}\cr
Response cookies. Will be translated to \code{Set-Cookie} headers.
\item \strong{\code{context}} :: \code{environment()}\cr
Environment to store any data. Can be used in middlewares.
\item \strong{\code{encode}} :: \code{function}\cr
unction to encode body for specific content
\item \strong{\code{status}} :: \code{character(1)}\cr
Paste together status code and description.
}
}

\section{Methods}{

\itemize{
\item \strong{\code{set_content_type}}\code{(content_type = 'text/plain')}\cr
\code{character(1)} -> \code{self}\cr
Set content type for response body.
\item \strong{\code{set_status_code}}\code{(code)}\cr
\code{integer(1)} -> \code{self}\cr
Set status code for response. See \href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Status}{docs on MDN}.
\item \strong{\code{has_header}}\code{(name)}\cr
\code{character(1)} -> \code{logical(1)}\cr
Determine whether or not the response header exists.
\item \strong{\code{get_header}}\code{(name, default = NULL)}\cr
\code{character(1)}, \code{character(1)} -> \code{character()}\cr
Get HTTP response header value. If requested header is empty returns \code{default}.
\item \strong{\code{set_header}}\code{(name, value)}\cr
\code{character(1)}, \code{character()} -> \code{self}\cr
Set HTTP response header. \code{Content-type} and \code{Content-length} headers not
allowed (use \code{content_type} field instead).
\item \strong{\code{append_header}}\code{(name, value)}\cr
\code{character(1)}, \code{character()} -> \code{self}\cr
Append HTTP response header. If header exists \code{,} separator will be used.
Don't use this method to set cookie (use \code{set_cookie} method instead).
\item \strong{\code{delete_header}}\code{(name)}\cr
\code{character(1)} -> \code{logical(1)}\cr
Unset HTTP response header.
\item \strong{\code{set_cookie}}\code{(name, value, expires = NULL, max_age = NULL, domain = NULL, path = NULL, secure = NULL, http_only = NULL)}\cr
\code{character(1)}, \code{character(1)}, \code{POSIXct(1)}, \code{integer(1)}, \code{character(1)},
\code{character(1)}, \code{logical(1)}, \code{logical(1)} -> \code{self}\cr
Set cookie. See \href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie}{docs on MDN}.
\item \strong{\code{unset_cookie}}\code{(name)}\cr
\code{character(1)} -> \code{logical(1)}\cr
Unset cookie with given name.
\item \strong{\code{set_date}}\code{(dtm = Sys.time())}\cr
\code{POSIXct(1)} -> \code{self}\cr
Set \code{Date} HTTP header. See \href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Date}{docs on MDN}.
\item \strong{\code{unset_date}}\code{()}\cr
-> \code{logical(1)}\cr
Unset \code{Date} HTTP header.
\item \strong{\code{set_body}}\code{(body)}\cr
\code{any} -> \code{self}\cr
Set response body.
\item \strong{\code{set_response}}\code{(status_code, body = NULL, content_type = self$content_type)}\cr
\code{integer(1)}, \code{any}, \code{character(1)} -> \code{self}\cr
Set response fields.
}
}

\examples{
# init response
rs = Response$new()
# set body media type
rs$set_content_type("text/plain")
# set body content
rs$set_body("OK")
# set response status code
rs$set_status_code(200L)
# print response
rs

# init response
rs = Response$new()
# static file path
file_path = system.file("DESCRIPTION", package = "RestRserve")
# get last file modification timestamp
file_mtime = file.mtime(file_path)
# set body
rs$set_body(c("file" = file_path))
# set content type
rs$set_content_type("text/plain")
# set current timestamp
rs$set_date()
# set 'last-modified' header
rs$set_header("Last-Modified", as(file_mtime, "HTTPDate"))
# print response
rs

}
\seealso{
\link{Request} \link{Application}
}
\keyword{datasets}
