/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docx4r.tools;

import java.math.BigInteger;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTVerticalAlignRun;
import org.docx4j.wml.CTVerticalJc;
import org.docx4j.wml.Color;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.STVerticalAlignRun;
import org.docx4j.wml.STVerticalJc;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.TcMar;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.U;
import org.docx4j.wml.UnderlineEnumeration;

public class Format {
    public static RPr getTextProperties(String color, int fontsize, boolean strbold, boolean italic, boolean underlined, String fontfamily, String valign) {
        CTVerticalAlignRun vv;
        BooleanDefaultTrue b;
        RPr runProperties = new RPr();
        HpsMeasure size = new HpsMeasure();
        size.setVal(BigInteger.valueOf(fontsize * 2));
        runProperties.setSz(size);
        RFonts rfonts = new RFonts();
        rfonts.setAscii(fontfamily);
        rfonts.setCs(fontfamily);
        rfonts.setHAnsi(fontfamily);
        runProperties.setRFonts(rfonts);
        if (strbold) {
            b = new BooleanDefaultTrue();
            b.setVal(Boolean.valueOf(true));
            runProperties.setB(b);
        }
        if (italic) {
            b = new BooleanDefaultTrue();
            b.setVal(Boolean.valueOf(true));
            runProperties.setI(b);
        }
        if (underlined) {
            U u = new U();
            u.setVal(UnderlineEnumeration.SINGLE);
            runProperties.setU(u);
        }
        if (valign.equals("subscript")) {
            vv = new CTVerticalAlignRun();
            vv.setVal(STVerticalAlignRun.SUBSCRIPT);
            runProperties.setVertAlign(vv);
        } else if (valign.equals("superscript")) {
            vv = new CTVerticalAlignRun();
            vv.setVal(STVerticalAlignRun.SUPERSCRIPT);
            runProperties.setVertAlign(vv);
        }
        Color col = new Color();
        col.setVal(color);
        runProperties.setColor(col);
        return runProperties;
    }

    public static PPr getParProperties(String textalign, int paddingbottom, int paddingtop, int paddingleft, int paddingright) {
        PPr parProperties = new PPr();
        Jc alignment = new Jc();
        if (textalign.equals("left")) {
            alignment.setVal(JcEnumeration.LEFT);
        } else if (textalign.equals("center")) {
            alignment.setVal(JcEnumeration.CENTER);
        } else if (textalign.equals("right")) {
            alignment.setVal(JcEnumeration.RIGHT);
        } else if (textalign.equals("justify")) {
            alignment.setVal(JcEnumeration.BOTH);
        }
        parProperties.setJc(alignment);
        PPrBase.Spacing space = new PPrBase.Spacing();
        space.setBefore(BigInteger.valueOf((long)paddingtop * 20L));
        space.setAfter(BigInteger.valueOf((long)paddingbottom * 20L));
        parProperties.setSpacing(space);
        PPrBase.Ind padding = new PPrBase.Ind();
        padding.setLeft(BigInteger.valueOf((long)paddingleft * 20L));
        padding.setRight(BigInteger.valueOf((long)paddingright * 20L));
        parProperties.setInd(padding);
        return parProperties;
    }

    public static TcPr getCellProperties(String borderBottomColor, String borderBottomStyle, int borderBottomWidth, String borderLeftColor, String borderLeftStyle, int borderLeftWidth, String borderTopColor, String borderTopStyle, int borderTopWidth, String borderRightColor, String borderRightStyle, int borderRightWidth, String verticalAlign, int paddingBottom, int paddingTop, int paddingLeft, int paddingRight, String backgroundColor) {
        TcPr tcPr = new TcPr();
        CTShd shd = new CTShd();
        shd.setFill(backgroundColor);
        tcPr.setShd(shd);
        TcPrInner.TcBorders tcb = new TcPrInner.TcBorders();
        tcb.setBottom(Format.getBorder(borderBottomColor, borderBottomStyle, borderBottomWidth));
        tcb.setLeft(Format.getBorder(borderLeftColor, borderLeftStyle, borderLeftWidth));
        tcb.setRight(Format.getBorder(borderRightColor, borderRightStyle, borderRightWidth));
        tcb.setTop(Format.getBorder(borderTopColor, borderTopStyle, borderTopWidth));
        tcPr.setTcBorders(tcb);
        CTVerticalJc valign = new CTVerticalJc();
        if (verticalAlign.equals("center")) {
            valign.setVal(STVerticalJc.CENTER);
        } else if (verticalAlign.equals("middle")) {
            valign.setVal(STVerticalJc.CENTER);
        } else if (verticalAlign.equals("top")) {
            valign.setVal(STVerticalJc.TOP);
        } else if (verticalAlign.equals("bottom")) {
            valign.setVal(STVerticalJc.BOTTOM);
        } else {
            valign.setVal(STVerticalJc.CENTER);
        }
        tcPr.setVAlign(valign);
        tcPr.setTcMar(Format.getMargins(paddingBottom, paddingTop, paddingLeft, paddingRight));
        return tcPr;
    }

    private static TcMar getMargins(int paddingBottom, int paddingTop, int paddingLeft, int paddingRight) {
        TcMar mar = new TcMar();
        TblWidth bottomWidth = new TblWidth();
        bottomWidth.setW(BigInteger.valueOf(paddingBottom * 20));
        bottomWidth.setType("dxa");
        mar.setBottom(bottomWidth);
        TblWidth topWidth = new TblWidth();
        topWidth.setW(BigInteger.valueOf(paddingTop * 20));
        topWidth.setType("dxa");
        mar.setTop(topWidth);
        TblWidth leftWidth = new TblWidth();
        leftWidth.setW(BigInteger.valueOf(paddingLeft * 20));
        leftWidth.setType("dxa");
        mar.setLeft(leftWidth);
        TblWidth rightWidth = new TblWidth();
        rightWidth.setW(BigInteger.valueOf(paddingRight * 20));
        rightWidth.setType("dxa");
        mar.setRight(rightWidth);
        return mar;
    }

    private static CTBorder getBorder(String borderColor, String borderStyle, int borderWidth) {
        CTBorder border = new CTBorder();
        if (borderWidth > 0 && !borderStyle.equals("none")) {
            border.setColor(borderColor);
            border.setSz(BigInteger.valueOf(borderWidth * 4));
            if (borderStyle.equals("solid")) {
                border.setVal(STBorder.SINGLE);
            } else if (borderStyle.equals("dotted")) {
                border.setVal(STBorder.DOTTED);
            } else if (borderStyle.equals("dashed")) {
                border.setVal(STBorder.DASHED);
            } else {
                border.setVal(STBorder.SINGLE);
            }
        } else {
            border.setVal(STBorder.NONE);
        }
        return border;
    }
}

