/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.docx4j.docProps.core.CoreProperties;
import org.docx4j.docProps.core.dc.elements.ObjectFactory;
import org.docx4j.docProps.core.dc.elements.SimpleLiteral;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblPr;
import org.lysis.reporters.docx4r.elements.DataTable;
import org.lysis.reporters.docx4r.elements.DrawingMLPlot;
import org.lysis.reporters.docx4r.elements.Image;
import org.lysis.reporters.docx4r.elements.POT;
import org.lysis.reporters.docx4r.elements.PageBreak;
import org.lysis.reporters.docx4r.elements.TableOfContent;
import org.lysis.reporters.docx4r.tools.BookmarkObject;
import org.lysis.reporters.docx4r.tools.DocExplorer;
import org.lysis.reporters.docx4r.tools.Format;
import org.lysis.reporters.tables.FlexTable;
import org.lysis.reporters.texts.ParProperties;

public class docx4R {
    private WordprocessingMLPackage basedoc;
    private int eltIndex = 0;
    private LinkedHashMap<String, String> styleDefinitions = new LinkedHashMap();

    private void listStyleNames() {
        Styles styles = (Styles)this.basedoc.getMainDocumentPart().getStyleDefinitionsPart().getJaxbElement();
        for (Style s : styles.getStyle()) {
            if (!s.getType().equals("paragraph")) continue;
            this.styleDefinitions.put(s.getStyleId(), s.getName().getVal());
        }
    }

    public String[] getStyleNames() {
        this.listStyleNames();
        String[] stylenames = new String[this.styleDefinitions.size()];
        int i = 0;
        Iterator<String> it1 = this.styleDefinitions.keySet().iterator();
        while (it1.hasNext()) {
            stylenames[i] = it1.next();
            ++i;
        }
        return stylenames;
    }

    private boolean existsStyleNames(String stylename) {
        Iterator<String> it1 = this.styleDefinitions.keySet().iterator();
        while (it1.hasNext()) {
            if (!it1.next().equals(stylename)) continue;
            return true;
        }
        return false;
    }

    public void setBaseDocument(String baseDocFileName) throws Exception {
        try {
            this.basedoc = WordprocessingMLPackage.load((InputStream)new FileInputStream(new File(baseDocFileName)));
        }
        catch (FileNotFoundException e) {
            throw new Exception("Cannot load base document [" + baseDocFileName + "]. File is not found.");
        }
        catch (Docx4JException e) {
            throw new Exception("Cannot load base document [" + baseDocFileName + "]. File is found but a Docx4J exception occured.");
        }
        this.listStyleNames();
    }

    public WordprocessingMLPackage getBaseDocument() {
        return this.basedoc;
    }

    public void incrementElementIndex(int inc) {
        this.eltIndex += inc;
    }

    public int getElementIndex() {
        return this.eltIndex;
    }

    public void writeDocxToStream(String target) throws Exception {
        File f = new File(target);
        try {
            this.basedoc.save(f);
        }
        catch (Docx4JException e) {
            throw new Exception("Cannot save document [" + target + "]. A Docx4J exception occured.");
        }
    }

    public void setDocPropertyTitle(String value) {
        DocPropsCorePart docProps = this.basedoc.getDocPropsCorePart();
        CoreProperties cp = (CoreProperties)docProps.getJaxbElement();
        ObjectFactory dcElfactory = new ObjectFactory();
        SimpleLiteral literal = dcElfactory.createSimpleLiteral();
        literal.getContent().add(value);
        cp.setTitle(dcElfactory.createTitle(literal));
    }

    public void setDocPropertyCreator(String value) {
        DocPropsCorePart docProps = this.basedoc.getDocPropsCorePart();
        CoreProperties cp = (CoreProperties)docProps.getJaxbElement();
        ObjectFactory dcElfactory = new ObjectFactory();
        SimpleLiteral literal = dcElfactory.createSimpleLiteral();
        literal.getContent().add(value);
        cp.setCreator(literal);
    }

    public void addPageBreak() throws Exception {
        ++this.eltIndex;
        this.basedoc.getMainDocumentPart().addObject((Object)PageBreak.getBreak());
    }

    public void add(Object obj) throws Exception {
        ++this.eltIndex;
        this.basedoc.getMainDocumentPart().addObject(obj);
    }

    public void addTableOfContents() throws Exception {
        ++this.eltIndex;
        TableOfContent.addTableOfContents(this.basedoc.getMainDocumentPart());
    }

    public void addTableOfContents(String stylename) throws Exception {
        ++this.eltIndex;
        if (!this.existsStyleNames(stylename)) {
            throw new Exception(String.valueOf(stylename) + " does not exist.");
        }
        TableOfContent.addTableOfContents(this.basedoc.getMainDocumentPart(), stylename);
    }

    public void deleteBookmark(String bookmark) {
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        if (bo.exists()) {
            P p = bo.getP();
            ((ContentAccessor)p.getParent()).getContent().remove(p);
        }
    }

    public void deleteBookmarkNextContent(String bookmark) {
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        if (bo.exists()) {
            P p = bo.getP();
            int i = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
            if (((ContentAccessor)p.getParent()).getContent().size() > i + 1) {
                ((ContentAccessor)p.getParent()).getContent().remove(i + 1);
            }
        }
    }

    public void add(DataTable dt, ParProperties pp) throws Exception {
        ++this.eltIndex;
        String textalign = pp.getTextalign();
        Tbl tbl = dt.getTbl();
        TblPr tblpr = tbl.getTblPr();
        Jc alignment = new Jc();
        if (textalign.equals("left")) {
            alignment.setVal(JcEnumeration.LEFT);
        } else if (textalign.equals("center")) {
            alignment.setVal(JcEnumeration.CENTER);
        } else if (textalign.equals("right")) {
            alignment.setVal(JcEnumeration.RIGHT);
        } else if (textalign.equals("justify")) {
            alignment.setVal(JcEnumeration.BOTH);
        }
        tblpr.setJc(alignment);
        this.basedoc.getMainDocumentPart().addObject((Object)tbl);
    }

    public void insert(String bookmark, DataTable table, ParProperties pp) throws Exception {
        ++this.eltIndex;
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        String textalign = pp.getTextalign();
        Tbl tbl = table.getTbl();
        TblPr tblpr = tbl.getTblPr();
        Jc alignment = new Jc();
        if (textalign.equals("left")) {
            alignment.setVal(JcEnumeration.LEFT);
        } else if (textalign.equals("center")) {
            alignment.setVal(JcEnumeration.CENTER);
        } else if (textalign.equals("right")) {
            alignment.setVal(JcEnumeration.RIGHT);
        } else if (textalign.equals("justify")) {
            alignment.setVal(JcEnumeration.BOTH);
        }
        tblpr.setJc(alignment);
        if (!bo.exists()) {
            throw new Exception("can't find bookmark '" + bookmark + "'.");
        }
        P p = bo.getP();
        int i = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
        ((ContentAccessor)p.getParent()).getContent().add(i + 1, tbl);
    }

    public void add(FlexTable dt, ParProperties pp) throws Exception {
        ++this.eltIndex;
        String textalign = pp.getTextalign();
        Tbl tbl = dt.getDocxTbl();
        TblPr tblpr = tbl.getTblPr();
        Jc alignment = new Jc();
        if (textalign.equals("left")) {
            alignment.setVal(JcEnumeration.LEFT);
        } else if (textalign.equals("center")) {
            alignment.setVal(JcEnumeration.CENTER);
        } else if (textalign.equals("right")) {
            alignment.setVal(JcEnumeration.RIGHT);
        } else if (textalign.equals("justify")) {
            alignment.setVal(JcEnumeration.BOTH);
        }
        tblpr.setJc(alignment);
        this.basedoc.getMainDocumentPart().addObject((Object)tbl);
    }

    public void add(String bookmark, FlexTable dt, ParProperties pp) throws Exception {
        ++this.eltIndex;
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        String textalign = pp.getTextalign();
        Tbl tbl = dt.getDocxTbl();
        TblPr tblpr = tbl.getTblPr();
        Jc alignment = new Jc();
        if (textalign.equals("left")) {
            alignment.setVal(JcEnumeration.LEFT);
        } else if (textalign.equals("center")) {
            alignment.setVal(JcEnumeration.CENTER);
        } else if (textalign.equals("right")) {
            alignment.setVal(JcEnumeration.RIGHT);
        } else if (textalign.equals("justify")) {
            alignment.setVal(JcEnumeration.BOTH);
        }
        tblpr.setJc(alignment);
        if (!bo.exists()) {
            throw new Exception("can't find bookmark '" + bookmark + "'.");
        }
        P p = bo.getP();
        int i = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
        ((ContentAccessor)p.getParent()).getContent().add(i + 1, tbl);
    }

    public void add(POT pot) {
        ++this.eltIndex;
        int i = 0;
        while (i < pot.getLength()) {
            this.basedoc.getMainDocumentPart().addObject((Object)pot.getP(i));
            ++i;
        }
    }

    public void insert(String bookmark, POT pot) throws Exception {
        ++this.eltIndex;
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        if (bo.exists()) {
            P p = bo.getP();
            int i = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
            ((ContentAccessor)p.getParent()).getContent().remove(i);
            pot.setBookmark(bookmark, bo.getBookmarkID());
            int pid = 0;
            while (pid < pot.getLength()) {
                ((ContentAccessor)p.getParent()).getContent().add(i + pid, pot.getP(pid));
                ++pid;
            }
        } else {
            throw new Exception("can't find bookmark '" + bookmark + "'.");
        }
    }

    public void addImage(String[] filename, int[] dims, String textalign, int paddingbottom, int paddingtop, int paddingleft, int paddingright) throws Exception {
        int width = dims[0];
        int height = dims[1];
        PPr ppr = Format.getParProperties(textalign, paddingbottom, paddingtop, paddingleft, paddingright);
        int f = 0;
        while (f < filename.length) {
            Image img = new Image(filename[f]);
            this.basedoc.getMainDocumentPart().addObject((Object)img.addImageToPackage(this.basedoc, this.eltIndex + 1, this.eltIndex + 2, width, height, ppr));
            this.eltIndex += 2;
            ++f;
        }
    }

    public void insertImage(String bookmark, String[] filename, int[] dims, String textalign, int paddingbottom, int paddingtop, int paddingleft, int paddingright) throws Exception {
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        int width = dims[0];
        int height = dims[1];
        PPr ppr = Format.getParProperties(textalign, paddingbottom, paddingtop, paddingleft, paddingright);
        if (bo.exists()) {
            P p = bo.getP();
            int i = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
            ((ContentAccessor)p.getParent()).getContent().remove(i);
            int f = 0;
            while (f < filename.length) {
                Image img = new Image(filename[f]);
                if (f == 0) {
                    img.setBookmark(bookmark, bo.getBookmarkID());
                }
                ((ContentAccessor)p.getParent()).getContent().add(i + f, img.addImageToPackage(this.basedoc, this.eltIndex + 1, this.eltIndex + 2, width, height, ppr));
                this.eltIndex += 2;
                ++f;
            }
        } else {
            throw new Exception("can't find bookmark '" + bookmark + "'.");
        }
    }

    public void addDML(String[] filename, int[] dims, String textalign, int paddingbottom, int paddingtop, int paddingleft, int paddingright) throws Exception {
        int width = dims[0];
        int height = dims[1];
        PPr ppr = Format.getParProperties(textalign, paddingbottom, paddingtop, paddingleft, paddingright);
        int f = 0;
        while (f < filename.length) {
            DrawingMLPlot dml = new DrawingMLPlot(filename[f]);
            P altp = dml.getP(width, height, this.eltIndex, ppr);
            this.add(altp);
            this.eltIndex += 2;
            ++f;
        }
    }

    public void insertDML(String bookmark, String[] filename, int[] dims, String textalign, int paddingbottom, int paddingtop, int paddingleft, int paddingright) throws Exception {
        BookmarkObject bo = DocExplorer.getBookmarkObject(bookmark, this.basedoc);
        PPr ppr = Format.getParProperties(textalign, paddingbottom, paddingtop, paddingleft, paddingright);
        if (bo.exists()) {
            P p = bo.getP();
            int width = dims[0];
            int height = dims[1];
            int i = ((ContentAccessor)p.getParent()).getContent().indexOf(p);
            ((ContentAccessor)p.getParent()).getContent().remove(i);
            int f = 0;
            while (f < filename.length) {
                DrawingMLPlot dml = new DrawingMLPlot(filename[f]);
                if (f == 0) {
                    dml.setBookmark(bookmark, bo.getBookmarkID());
                }
                ((ContentAccessor)p.getParent()).getContent().add(i + f, dml.getP(width, height, this.eltIndex, ppr));
                this.eltIndex += 2;
                ++f;
            }
        } else {
            throw new Exception("can't find bookmark '" + bookmark + "'.");
        }
    }
}

