% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GA_diagplot.R
\name{GA_diagplot}
\alias{GA_diagplot}
\title{Diagnostic plot for comparison of two correlation matrices.}
\usage{
GA_diagplot(
  R,
  Rt,
  eps = 0.05,
  col.method = "trafficlight",
  color = c(0, 8),
  top = ""
)
}
\arguments{
\item{R}{Specified correlation matrix.}

\item{Rt}{Correlation matrix of the data generated by the genetic
algorithm.}

\item{eps}{Permitted difference between the entries of two
matrices. Must only be specified if col.method="trafficlight".}

\item{col.method}{Method to use for color scaling the difference
between the matrices. If method="trafficlight" only two colors
are used, indicating whether the entries deviated at least by a
difference of eps. If method="updown" a discrete gray scale is
used.}

\item{color}{Value of two color that are used if method="trafficlight"}

\item{top}{Specifies the main title of the plot}
}
\description{
A diagnostic plot that compares the entries of two correlation
matrices using a color scale.
}
\details{
A diagnostic plot that compares the entries of two correlation
matrices using a color scale.
}
\examples{
R1 = diag(10)
X0 <- start_matrix(p=c(0.4, 0.2, 0.5, 0.15, 0.4, 0.35, 0.2, 0.25, 0.3, 0.4), k = 5000)
Xt <- iter_matrix(X0, R = diag(10), T = 10000, e.min = 0.00001)
GA_diagplot(R1, Rt = Xt$Rt, col.method = "trafficlight")
GA_diagplot(R1, Rt = Xt$Rt, col.method = "updown")
}
\references{
Kruppa, J., Lepenies, B., & Jung, K. (2018). A genetic algorithm for simulating correlated binary data from biomedical research. \emph{Computers in biology and medicine}, \strong{92}, 1-8. \doi{10.1016/j.compbiomed.2017.10.023}
}
\author{
Jochen Kruppa, Klaus Jung
}
