% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_gca.R
\name{pca_gca}
\alias{pca_gca}
\title{PCA-GCA method for selecting the number of common and distinctive components.}
\usage{
pca_gca(DATA, Jk, cor_min, return_scores)
}
\arguments{
\item{DATA}{A concatenated data matrix with the same number of rows.}

\item{Jk}{A vector containing number of variables  in the concatinated data matrix. Please see the example below.}

\item{cor_min}{The minimum correlation between two components. The default value is .7; thus, it means that if the correlation
between the two component is at least .7, then these two components are regarded as forming a single common component.}

\item{return_scores}{If TRUE, then the function will return the component scores for each block for further analysis.}
}
\value{
It prints out the number of components of each block and the number of common components. It also returns the component scores for each block for further analysis, if \code{return_scores = TRUE}.
}
\description{
Use PCA-GCA method to identify the number of common and distinctive components.
}
\note{
Please be ware of the interactive input: The function first performs PCA on each data block and then displays the eigenvalues (and a scree plot).
Afterwards the function awaits the input from the user - it needs to know how many components need to be retained for that block.
}
\examples{
\dontrun{
DATA1 <- matrix(rnorm(50), nrow=5)
DATA2 <- matrix(rnorm(100), nrow=5)
DATA <- cbind(DATA1, DATA2)
R <- 5
Jk <- c(10, 20) 
pca_gca(DATA, Jk, cor_min = .8)
}
}
\references{
Tenenhaus, A., & Tenenhaus, M. (2011). Regularized generalized canonical correlation analysis. Psychometrika, 76(2), 257-284.

Smilde, A.K., Mage, I., Naes, T., Hankemeier, T., Lips, M.A., Kiers, H.A., Acar, E., & Bro, R. (2016). Common and distinct components in data fusion. arXiv preprint arXiv:1607.02328.
}
