% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/RedditExtractoR.R
\name{ObtainRedditURLs}
\alias{ObtainRedditURLs}
\title{Obtain URLs from which information will be extracted}
\usage{
ObtainRedditURLs(search_terms, regex_filter = "", cn_threshold = 50,
  page_threshold = 1, wait_time = 2)
}
\arguments{
\item{search_terms}{A string of terms to be searched on Reddit}

\item{regex_filter}{An optional regular expression filter that will remove URLs with titles that do not match the condition.}

\item{cn_threshold}{Comment number threshold that remove URLs with fewer comments that cn_threshold. 10 by default.}

\item{page_threshold}{Page threshold that controls the number of pages is going to be searched for a given search word. 100 by default.}

\item{wait_time}{wait time in seconds between page requests. 2 by default and it is also the minimum (API rate limit).}
}
\value{
A data frame with URLs (links), number of comments (num_comments), title (title) and date (date).
}
\description{
Takes search terms and a range of conditions and returns reddit URLs to relevant links
}
\examples{
example_urls = ObtainRedditURLs(search_terms="science")
}

